/*
 * $Id: Replaceable.java 23 2007-02-16 07:44:41Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

/**
 * defines a replaceable value.
 * 
 * @author Max Antoni
 * @version $Revision: 23 $
 */
public interface Replaceable {

    /**
     * replaces this replaceable using the given context.
     * 
     * @param inContext the context.
     * @return the replaced object.
     * @throws PropertiesException
     */
    public abstract Object replace(Context inContext)
            throws PropertiesException;

    /**
     * writes this replaceable to the given writer.
     * 
     * @param inoutWriter the writer.
     */
    public abstract void write(Writer inoutWriter);

    /**
     * copies this replaceable.
     * 
     * @param inParent the parent properties.
     * @return the copy of this replaceable.
     */
    public abstract Replaceable copy(Properties inParent);

}
