/*
 * $Id: MapPropertiesTest.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.io.IOException;
import java.util.Map;

import junit.framework.TestCase;

/**
 * @author Max Antoni
 * @version $Revision: 109 $
 */
public class MapPropertiesTest extends TestCase {
    
    public void testJokerKey() throws IOException {
        Map properties = new MapProperties(
                "classpath://com/eva/properties/jokerkey.eva");
        assertEquals("eins", properties.get("foo.1"));
        assertEquals("zwei", properties.get("foo.2"));
        assertEquals("drei", properties.get("foo.3"));
        assertEquals("Joker", properties.get("foo.4"));
        
        assertEquals("eins", properties.get("bar.1"));
        assertEquals("zwei", properties.get("bar.2"));
        assertEquals("drei", properties.get("bar.3"));
        assertNull(properties.get("bar.4"));
        
        assertEquals("Root Joker", properties.get("doo"));
    }
    
    public void testSet() {
        Map map = new MapProperties();
        map.put("a.b.c", "Hiya");
        assertEquals("Hiya", map.get("a.b.c"));
        assertTrue(map.get("a") instanceof Map);
        assertTrue(((Map) map.get("a")).get("b") instanceof Map);
        assertEquals("Hiya", ((Map) ((Map) map.get("a")).get("b")).get("c"));
    }
    
    public void testStartParameters() {
        Map map = new MapProperties(new String[] {
            "eva.home=\"/some/path\""
        });
        assertEquals("/some/path", map.get("eva.home"));
    }
    
    public void testNestedProperties() {
        Map map = (Map) PropertiesParser.readObject("{ inner: { x: 'y' } }");
        Object inner = map.get("inner");
        assertNotNull(inner);
        assertTrue(inner instanceof MapProperties);
        MapProperties innerMap = (MapProperties) inner;
        Object x = innerMap.get("x");
        assertNotNull(x);
        assertTrue(x instanceof Character);
        assertEquals(new Character('y'), x);
        assertNotNull(innerMap.getParent());
        assertSame(map, innerMap.getParent());
    }

}