/*
 * Decompiled with CFR 0.152.
 */
package com.eva.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class LogFormatter
extends Formatter {
    private static DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2);
    private static final String COLON = ": ";
    private static final String NEWLINE = "\n";
    private String prefix;

    public LogFormatter() {
    }

    public LogFormatter(String inPrefix) {
        this.prefix = inPrefix;
    }

    public String format(LogRecord inLogRecord) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(DATE_FORMAT.format(new Date(inLogRecord.getMillis())));
        buffer.append(' ');
        buffer.append(inLogRecord.getLevel().getLocalizedName());
        if (inLogRecord.getMessage() == null) {
            buffer.append(COLON);
            buffer.append(inLogRecord.getSourceClassName());
            buffer.append('#');
            buffer.append(inLogRecord.getSourceMethodName());
        } else {
            if (this.prefix != null) {
                buffer.append(' ');
                buffer.append(this.prefix);
            }
            buffer.append(COLON);
            buffer.append(this.formatMessage(inLogRecord));
        }
        buffer.append(NEWLINE);
        Throwable throwable = inLogRecord.getThrown();
        if (throwable != null) {
            StringWriter aStringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(aStringWriter));
            buffer.append(aStringWriter.getBuffer());
            buffer.append(NEWLINE);
        }
        return buffer.toString();
    }
}

