/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Log;
import com.eva.properties.Properties;
import com.eva.properties.PropertiesException;
import com.eva.properties.ProtocolFactory;
import com.eva.properties.Replaceable;
import com.eva.properties.Replacer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

class Context {
    private List currentKeys;
    private Context parent;
    private Properties properties;

    Context(Context inParent, Properties inProperties) {
        if (inParent == null) {
            throw new NullPointerException("Parent context is null.");
        }
        this.parent = inParent;
        this.setProperties(inProperties);
    }

    Context(Properties inProperties) {
        this.setProperties(inProperties);
    }

    Context getParent() {
        if (this.parent == null) {
            Properties p = this.properties.getParent();
            this.parent = p == null ? null : new Context(p);
        }
        return this.parent;
    }

    boolean isDebug() {
        return Properties.DEBUG || Log.instance().isLoggable(Level.FINE);
    }

    Class loadClass(String inClassName) {
        try {
            return this.getClassLoader().loadClass(inClassName);
        }
        catch (SecurityException e) {
            throw new PropertiesException("Cannot load \"" + inClassName + "\": " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new PropertiesException("Class \"" + inClassName + "\" not found .");
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = (ClassLoader)this.lookup("classloader");
        if (classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookup(String inKey) throws PropertiesException {
        if (inKey.startsWith(".")) {
            if (this.getParent() == null) {
                return null;
            }
            return this.parent.lookup(inKey.substring(1));
        }
        if (this.isDebug()) {
            if (this.currentKeys.contains(inKey)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Recursive references: ");
                this.writePathHelper(buffer);
                buffer.append(inKey);
                throw new PropertiesException(buffer.toString());
            }
            this.currentKeys.add(inKey);
            try {
                Object object = this.lookupHelper(inKey);
                return object;
            }
            finally {
                this.currentKeys.remove(this.currentKeys.size() - 1);
            }
        }
        return this.lookupHelper(inKey);
    }

    Object replace(Object inValue) throws PropertiesException {
        if (inValue instanceof Replaceable) {
            return this.replaceReplaceable((Replaceable)inValue);
        }
        if (inValue instanceof String) {
            return this.replaceString((String)inValue);
        }
        return inValue;
    }

    Object replaceReplaceable(Replaceable inReplaceable) {
        try {
            return inReplaceable.replace(this);
        }
        catch (PropertiesException e) {
            throw new PropertiesException("Cannot replace " + inReplaceable.toString() + ", " + e.getMessage(), e);
        }
    }

    Object replaceString(String inString) throws PropertiesException {
        String replaced = Replacer.replace(inString, this);
        if (replaced == null) {
            return null;
        }
        return ProtocolFactory.forString(this, replaced);
    }

    void writePath(StringBuffer inoutBuffer) {
        if (this.getParent() != null) {
            int length = inoutBuffer.length();
            this.parent.writePath(inoutBuffer);
            if (length < inoutBuffer.length()) {
                inoutBuffer.append(" > ");
            }
        }
        this.writePathHelper(inoutBuffer);
    }

    private Object lookupHelper(String inKey) {
        Object value = this.properties.getProperty(this, inKey);
        if (value == null && this.getParent() != null) {
            return this.parent.lookupHelper(inKey);
        }
        return value;
    }

    private void setProperties(Properties inProperties) {
        if (inProperties == null) {
            throw new NullPointerException("Properties is null.");
        }
        this.properties = inProperties;
        if (this.isDebug()) {
            this.currentKeys = new ArrayList();
        }
    }

    private void writePathHelper(StringBuffer inoutBuffer) {
        Iterator i = this.currentKeys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            inoutBuffer.append(key);
            inoutBuffer.append(" > ");
        }
    }
}

