/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Context;
import com.eva.properties.ListProperties;
import com.eva.properties.Properties;
import com.eva.properties.PropertiesException;
import com.eva.properties.Replaceable;
import com.eva.properties.Replacer;
import com.eva.properties.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class Factory
implements Replaceable {
    private Object[] arguments;
    private String className;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;

    public Factory(String inClassName) {
        this(inClassName, null);
    }

    public Factory(String inClassName, Object[] inArguments) {
        if (inClassName == null) {
            throw new NullPointerException("Classname cannot be null.");
        }
        if ("".equals(inClassName)) {
            throw new IllegalArgumentException("Classname cannot be empty.");
        }
        this.className = inClassName;
        this.arguments = inArguments;
    }

    public Replaceable copy(Properties inParent) {
        if (this.arguments == null) {
            return new Factory(this.className);
        }
        Object[] newArguments = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            newArguments[i] = this.arguments[i] instanceof Properties ? ((Properties)this.arguments[i]).copy(inParent) : (this.arguments[i] instanceof Replaceable ? ((Replaceable)this.arguments[i]).copy(inParent) : this.arguments[i]);
        }
        return new Factory(this.className, newArguments);
    }

    public Object replace(Context inContext) throws PropertiesException {
        Object[] replacedArguments = this.replacedArguments(inContext);
        Constructor constructor = this.findConstructor(inContext, replacedArguments);
        if (replacedArguments != null) {
            this.replaceListProperties(replacedArguments, constructor);
        }
        try {
            return constructor.newInstance(replacedArguments);
        }
        catch (IllegalArgumentException e) {
            throw new PropertiesException(e);
        }
        catch (InstantiationException e) {
            throw new PropertiesException(e);
        }
        catch (IllegalAccessException e) {
            throw new PropertiesException(e);
        }
        catch (InvocationTargetException e) {
            throw new PropertiesException(e.getCause());
        }
    }

    public String toString() {
        Writer writer = new Writer();
        this.write(writer);
        return writer.toString();
    }

    public void write(Writer inoutWriter) {
        inoutWriter.append('*');
        inoutWriter.append(this.className);
        if (this.arguments == null) {
            inoutWriter.append('\n');
        } else {
            inoutWriter.append("(\n");
            for (int i = 0; i < this.arguments.length; ++i) {
                inoutWriter.increaseIndentation();
                inoutWriter.write(this.arguments[i]);
                inoutWriter.decreaseIndentation();
            }
            inoutWriter.appendIndentation();
            inoutWriter.append(")\n");
        }
    }

    private Constructor findConstructor(Context inContext, Object[] inoutArguments) throws PropertiesException {
        Class clazz;
        String replacedClassName = Replacer.replace(this.className, inContext);
        if (replacedClassName == null) {
            replacedClassName = this.className;
        }
        if ((clazz = inContext.loadClass(replacedClassName)) == null) {
            throw new PropertiesException("Class not found: " + replacedClassName);
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class[] parameterTypes = constructors[i].getParameterTypes();
            if (!this.matches(parameterTypes, inoutArguments)) continue;
            return constructors[i];
        }
        String message = this.getNotFoundMessage(replacedClassName, inoutArguments);
        throw new PropertiesException(message);
    }

    private String getNotFoundMessage(String inClassName, Object[] inArguments) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("No matching constructor found for \"");
        buffer.append(inClassName);
        buffer.append('(');
        if (inArguments != null) {
            for (int i = 0; i < inArguments.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(inArguments[i].getClass().getName());
            }
        }
        buffer.append(")\"");
        return buffer.toString();
    }

    private boolean matches(Class[] inClasses, Object[] inoutObjects) {
        if (inoutObjects == null) {
            return inClasses.length == 0;
        }
        if (inClasses.length != inoutObjects.length) {
            return false;
        }
        for (int i = 0; i < inClasses.length; ++i) {
            if (inoutObjects[i] == null || inClasses[i].isInstance(inoutObjects[i]) || inClasses[i].isArray()) continue;
            if (inClasses[i].isPrimitive()) {
                if (inClasses[i] == Boolean.TYPE && inoutObjects[i].getClass() == (class$java$lang$Boolean == null ? Factory.class$("java.lang.Boolean") : class$java$lang$Boolean) || inClasses[i] == Character.TYPE && inoutObjects[i].getClass() == (class$java$lang$Character == null ? Factory.class$("java.lang.Character") : class$java$lang$Character)) continue;
                if ((class$java$lang$Number == null ? Factory.class$("java.lang.Number") : class$java$lang$Number).isInstance(inoutObjects[i])) {
                    Number number = (Number)inoutObjects[i];
                    if (inClasses[i] == Integer.TYPE) {
                        inoutObjects[i] = new Integer(number.intValue());
                        continue;
                    }
                    if (inClasses[i] == Long.TYPE) {
                        inoutObjects[i] = new Long(number.longValue());
                        continue;
                    }
                    if (inClasses[i] == Float.TYPE) {
                        inoutObjects[i] = new Float(number.floatValue());
                        continue;
                    }
                    if (inClasses[i] == Double.TYPE) {
                        inoutObjects[i] = new Double(number.doubleValue());
                        continue;
                    }
                    if (inClasses[i] == Byte.TYPE) {
                        inoutObjects[i] = new Byte(number.byteValue());
                        continue;
                    }
                    if (inClasses[i] == Short.TYPE) {
                        inoutObjects[i] = new Short(number.shortValue());
                        continue;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private Object[] replacedArguments(Context inContext) throws PropertiesException {
        if (this.arguments == null) {
            return null;
        }
        Object[] args = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            args[i] = inContext.replace(this.arguments[i]);
        }
        return args;
    }

    private void replaceListProperties(Object[] inoutArguments, Constructor inConstructor) {
        for (int i = 0; i < inoutArguments.length; ++i) {
            Class<?> parameterType = inConstructor.getParameterTypes()[i];
            if (!(inoutArguments[i] instanceof List) || !parameterType.isArray()) continue;
            List list = (List)inoutArguments[i];
            Class<?> type = parameterType.getComponentType();
            inoutArguments[i] = list instanceof ListProperties ? ((ListProperties)list).toArray(type) : list.toArray((Object[])Array.newInstance(type, list.size()));
        }
    }
}

