/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Context;
import com.eva.properties.DataSource;
import com.eva.properties.MapProperties;
import com.eva.properties.Properties;
import com.eva.properties.PropertiesException;
import com.eva.properties.PropertiesParser;
import com.eva.properties.Replaceable;
import com.eva.properties.Writer;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ListProperties
extends Properties
implements List {
    private List list = new ArrayList();

    public ListProperties() {
    }

    public ListProperties(String inPath) throws PropertiesException, FileNotFoundException {
        if (inPath == null) {
            throw new NullPointerException("Path is null.");
        }
        PropertiesParser.readList(this, new DataSource(inPath));
    }

    public ListProperties(ClassLoader inClassLoader, String inPath) throws PropertiesException, FileNotFoundException {
        if (inClassLoader == null) {
            throw new NullPointerException("ClassLoader is null.");
        }
        if (inPath == null) {
            throw new NullPointerException("Path is null.");
        }
        PropertiesParser.readList(this, new DataSource(inClassLoader, inPath));
    }

    public ListProperties(DataSource inDataSource) throws PropertiesException {
        if (inDataSource == null) {
            throw new NullPointerException("DataSource is null.");
        }
        PropertiesParser.readList(this, inDataSource);
    }

    public ListProperties(InputStream inStream) throws PropertiesException {
        if (inStream == null) {
            throw new NullPointerException("Stream is null.");
        }
        PropertiesParser.readList(this, new InputStreamReader(inStream));
    }

    public ListProperties(List inList) {
        if (inList == null) {
            throw new NullPointerException("List is null.");
        }
        if (inList instanceof Properties) {
            this.setParent((Properties)((Object)inList));
        } else {
            this.addAll((Collection)inList);
        }
    }

    public ListProperties(Map inMap) {
        if (inMap == null) {
            throw new NullPointerException("Map is null.");
        }
        if (inMap instanceof Properties) {
            this.setParent((Properties)((Object)inMap));
        } else {
            this.setParent(new MapProperties(inMap));
        }
    }

    public ListProperties(Reader inReader) throws PropertiesException {
        if (inReader == null) {
            throw new NullPointerException("Reader is null.");
        }
        PropertiesParser.readList(this, inReader);
    }

    public ListProperties(Properties inParent) {
        super(inParent);
    }

    public void add(int inIndex, Object inValue) {
        this.list.add(inIndex, inValue);
    }

    public boolean add(Object inValue) {
        return this.list.add(inValue);
    }

    public boolean addAll(Collection inValues) {
        return this.list.addAll(inValues);
    }

    public boolean addAll(int inIndex, Collection inValues) {
        return this.list.addAll(inIndex, inValues);
    }

    public void clear() {
        this.list.clear();
    }

    public boolean contains(Object inValue) {
        return this.list.contains(inValue);
    }

    public boolean containsAll(Collection inValues) {
        return this.list.containsAll(inValues);
    }

    public Object get(int inIndex) {
        try {
            return new Context(this).replace(this.list.get(inIndex));
        }
        catch (PropertiesException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new PropertiesException("Cannot resolve \"" + inIndex + "\", " + e.getMessage());
            }
            throw new PropertiesException("Cannot resolve \"" + inIndex + "\":", cause);
        }
    }

    public int indexOf(Object inValue) {
        return this.list.indexOf(inValue);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Iterator iterator() {
        return new ListPropertiesIterator();
    }

    public int lastIndexOf(Object inValue) {
        return this.list.lastIndexOf(inValue);
    }

    public int length() {
        return this.list.size();
    }

    public ListIterator listIterator() {
        return new ListPropertiesIterator();
    }

    public ListIterator listIterator(int inIndex) {
        return new ListPropertiesIterator(inIndex);
    }

    public Object remove(int inIndex) {
        return this.list.remove(inIndex);
    }

    public boolean remove(Object inValue) {
        return this.list.remove(inValue);
    }

    public boolean removeAll(Collection inValues) {
        return this.list.removeAll(inValues);
    }

    public boolean retainAll(Collection inValues) {
        return this.list.retainAll(inValues);
    }

    public Object set(int inIndex, Object inValue) {
        return this.list.set(inIndex, inValue);
    }

    public int size() {
        return this.list.size();
    }

    public List subList(int inFrom, int inLength) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        return this.toArray(Object.class);
    }

    public Object[] toArray(Object[] inArray) {
        Object[] array = this.toArray(inArray.getClass().getComponentType());
        if (array.length <= inArray.length) {
            System.arraycopy(array, 0, inArray, 0, array.length);
        }
        return array;
    }

    public List getList() {
        return this.list;
    }

    Properties copy(Properties inParent) {
        ListProperties newProperties = new ListProperties(inParent);
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (value instanceof Properties) {
                newProperties.list.add(((Properties)value).copy(newProperties));
                continue;
            }
            if (value instanceof Replaceable) {
                newProperties.list.add(((Replaceable)value).copy(newProperties));
                continue;
            }
            newProperties.list.add(value);
        }
        return newProperties;
    }

    Object getProperty(Context inContext, String inKey) throws PropertiesException {
        Object value;
        int p = inKey.indexOf(46);
        if (p > 0) {
            int index;
            String localKey = inKey.substring(0, p);
            String rightKey = inKey.substring(p + 1);
            if (localKey.equals("*")) {
                return this.createJokerList(inContext, rightKey);
            }
            if (this.list == null) {
                throw new IndexOutOfBoundsException();
            }
            try {
                index = Integer.parseInt(localKey);
            }
            catch (NumberFormatException e) {
                return null;
            }
            Object value2 = this.list.get(index);
            if (value2 instanceof Properties) {
                Properties inner = (Properties)value2;
                return inner.getProperty(new Context(inContext, inner), rightKey);
            }
        }
        if (inKey.equals("length")) {
            return new Integer(this.length());
        }
        if (this.list == null) {
            return null;
        }
        try {
            value = this.list.get(Integer.parseInt(inKey));
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (value == null) {
            return null;
        }
        return inContext.replace(value);
    }

    Object putProperty(Context inContext, String inKey, Object inValue) {
        int index;
        int p = inKey.indexOf(46);
        if (p > 0) {
            int index2;
            String key = inKey.substring(0, p);
            try {
                index2 = Integer.parseInt(inKey);
            }
            catch (NumberFormatException e) {
                throw new PropertiesException(key + " is not a number.");
            }
            if (index2 > this.list.size()) {
                throw new PropertiesException("Index out of bounds, " + index2 + " > " + this.list.size());
            }
            Object value = this.list.get(index2);
            if (value instanceof Replaceable) {
                value = inContext.replaceReplaceable((Replaceable)value);
            }
            if (value instanceof Properties) {
                Properties inner = (Properties)value;
                return inner.putProperty(new Context(inContext, inner), inKey.substring(p + 1), inValue);
            }
            throw new PropertiesException(key + " is neither a map nor a list, " + String.valueOf(value));
        }
        try {
            index = Integer.parseInt(inKey);
        }
        catch (NumberFormatException e) {
            throw new PropertiesException("\"" + inKey + "\" is not a number.");
        }
        while (this.list.size() <= index) {
            this.list.add(null);
        }
        return this.list.set(index, inValue);
    }

    public Object[] toArray(Class inClass) {
        Object[] array = (Object[])Array.newInstance(inClass, this.list.size());
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    void write(Writer inoutWriter) {
        inoutWriter.append("[\n");
        inoutWriter.increaseIndentation();
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            inoutWriter.appendIndentation();
            inoutWriter.write(i.next());
        }
        inoutWriter.decreaseIndentation();
        inoutWriter.appendIndentation();
        inoutWriter.append("]\n");
    }

    private ListProperties createJokerList(Context inContext, String rightKey) throws PropertiesException {
        ListProperties l = new ListProperties(this);
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (!(value instanceof Properties) || (value = ((Properties)value).getProperty(inContext, rightKey)) == null) continue;
            l.add(value);
        }
        return l;
    }

    private class ListPropertiesIterator
    implements ListIterator {
        private int index;

        ListPropertiesIterator() {
        }

        ListPropertiesIterator(int inIndex) {
            this.index = inIndex;
        }

        public void add(Object inValue) {
            ListProperties.this.add(inValue);
        }

        public boolean hasNext() {
            return this.index < ListProperties.this.size();
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public Object next() {
            return ListProperties.this.get(this.index++);
        }

        public int nextIndex() {
            return this.index;
        }

        public Object previous() {
            return ListProperties.this.get(--this.index);
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            ListProperties.this.remove(--this.index);
        }

        public void set(Object inValue) {
            ListProperties.this.set(this.index, inValue);
        }
    }
}

