/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Context;
import com.eva.properties.DataSource;
import com.eva.properties.Log;
import com.eva.properties.PropertiesException;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class ProtocolFactory {
    private static final String PROTOCOL_CLASSPATH = "classpath";
    private static final String PROTOCOL_DATASOURCE = "datasource";
    private static final String PROTOCOL_FILE = "file";
    private static final String PROTOCOL_URL = "url";
    private static final String PROTOCOL_CLASS = "class";
    private static final String PROTOCOL_STATIC = "static";
    private static final String PROTOCOL_STRING = "string";
    private static final String COLON_SLASH_SLASH = "://";
    private static final Map PROTOCOL_FACTORIES;
    private static final Pattern PROTOCOL_PATTERN;

    static Object forString(Context inContext, String inString) throws PropertiesException {
        Matcher matcher = PROTOCOL_PATTERN.matcher(inString);
        if (matcher.matches()) {
            ProtocolFactory factory = (ProtocolFactory)PROTOCOL_FACTORIES.get(matcher.group(1));
            if (factory == null) {
                try {
                    return new URL(inString);
                }
                catch (MalformedURLException e) {
                    throw new PropertiesException(e);
                }
            }
            try {
                return factory.build(inContext, inString);
            }
            catch (FileNotFoundException e) {
                if (Log.instance().isLoggable(Level.FINE)) {
                    Log.instance().fine("Properties: File not found, " + e.getMessage());
                }
                return null;
            }
        }
        return inString;
    }

    ProtocolFactory() {
    }

    abstract Object build(Context var1, String var2) throws FileNotFoundException, PropertiesException;

    String removePrefix(String inUrl) {
        return inUrl.substring(inUrl.indexOf(COLON_SLASH_SLASH) + COLON_SLASH_SLASH.length());
    }

    static {
        PROTOCOL_PATTERN = Pattern.compile("^([a-z]{3,})\\:\\/\\/.*");
        PROTOCOL_FACTORIES = new HashMap();
        PROTOCOL_FACTORIES.put(PROTOCOL_STRING, new ProtocolFactory(){

            Object build(Context inContext, String inPath) {
                return this.removePrefix(inPath);
            }
        });
        PROTOCOL_FACTORIES.put(PROTOCOL_CLASS, new ProtocolFactory(){

            Object build(Context inContext, String inPath) {
                return inContext.loadClass(this.removePrefix(inPath));
            }
        });
        PROTOCOL_FACTORIES.put(PROTOCOL_STATIC, new ProtocolFactory(){

            Object build(Context inContext, String inPath) {
                Field field;
                String path = this.removePrefix(inPath);
                int p = path.indexOf(35);
                if (p == -1) {
                    throw new IllegalArgumentException("No hash found in " + inPath);
                }
                Class clazz = inContext.loadClass(path.substring(0, p));
                String instance = path.substring(p + 1);
                try {
                    field = clazz.getField(instance);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                if (Modifier.isStatic(field.getModifiers())) {
                    try {
                        return field.get(null);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new IllegalArgumentException(clazz.getName() + "#" + instance + " is not static.");
            }
        });
        PROTOCOL_FACTORIES.put(PROTOCOL_URL, new ProtocolFactory(){

            Object build(Context inContext, String inPath) throws FileNotFoundException {
                try {
                    return new URL(this.removePrefix(inPath));
                }
                catch (MalformedURLException e) {
                    throw new FileNotFoundException(e.getMessage());
                }
            }
        });
        PROTOCOL_FACTORIES.put(PROTOCOL_FILE, new ProtocolFactory(){

            Object build(Context inContext, String inPath) {
                return new File(this.removePrefix(inPath).replace('/', File.separatorChar));
            }
        });
        PROTOCOL_FACTORIES.put(PROTOCOL_DATASOURCE, new ProtocolFactory(){

            Object build(Context inContext, String inPath) throws FileNotFoundException, PropertiesException {
                return new DataSource((ClassLoader)inContext.lookup("classloader"), this.removePrefix(inPath));
            }
        });
        PROTOCOL_FACTORIES.put(PROTOCOL_CLASSPATH, new ProtocolFactory(){

            Object build(Context inContext, String inPath) throws FileNotFoundException, PropertiesException {
                return new DataSource((ClassLoader)inContext.lookup("classloader"), inPath);
            }
        });
    }
}

