/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Context;
import com.eva.properties.Log;
import com.eva.properties.PropertiesException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Replacer {
    private static final Pattern PLACEHOLDER = Pattern.compile("\\$\\{[a-zA-Z0-9_\\-\\.]+\\}");

    private Replacer() {
    }

    static String replace(String inValue, Context inContext) throws PropertiesException {
        Matcher matcher = PLACEHOLDER.matcher(inValue);
        if (!matcher.find()) {
            return inValue;
        }
        StringBuffer buffer = new StringBuffer();
        int pos = 0;
        do {
            String group;
            String placeholder;
            Object value;
            int s;
            if ((s = matcher.start()) > pos) {
                buffer.append(inValue.substring(pos, s));
            }
            if ((value = inContext.lookup(placeholder = (group = matcher.group()).substring(2, group.length() - 1))) == null) {
                if (Log.instance().isLoggable(Level.FINE)) {
                    StringBuffer message = new StringBuffer();
                    message.append(group);
                    message.append(" is null");
                    if (inContext.isDebug()) {
                        message.append(" (");
                        inContext.writePath(message);
                        message.append(placeholder);
                        message.append(")");
                    }
                    message.append(".");
                    Log.instance().log(Level.FINE, message.toString());
                }
                return null;
            }
            if (value instanceof File) {
                try {
                    buffer.append(((File)value).getCanonicalPath());
                }
                catch (IOException e) {
                    buffer.append(((File)value).getAbsolutePath());
                }
            } else if (value instanceof URL) {
                buffer.append(((URL)value).getFile());
            } else {
                buffer.append(value);
            }
            pos = matcher.end();
        } while (matcher.find());
        if (pos < inValue.length()) {
            buffer.append(inValue.substring(pos));
        }
        return buffer.toString();
    }
}

