/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Context;
import com.eva.properties.Log;
import com.eva.properties.NoProperties;
import com.eva.properties.Null;
import com.eva.properties.Properties;
import com.eva.properties.PropertiesException;
import com.eva.properties.Replaceable;
import com.eva.properties.Writer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;

public class Switch
implements Replaceable {
    private Collection alternatives;

    public Switch() {
        this.alternatives = new ArrayList();
    }

    public Switch(Collection inAlternatives) {
        this.alternatives = inAlternatives;
    }

    public void add(Object inAlternative) {
        this.alternatives.add(inAlternative);
    }

    public String toString() {
        Writer writer = new Writer();
        this.write(writer);
        return writer.toString();
    }

    public void write(Writer inoutWriter) {
        inoutWriter.append("(\n");
        inoutWriter.increaseIndentation();
        Iterator i = this.alternatives.iterator();
        while (i.hasNext()) {
            inoutWriter.write(i.next());
        }
        inoutWriter.decreaseIndentation();
        inoutWriter.appendIndentation();
        inoutWriter.append(")\n");
    }

    public Object replace(Context inContext) throws PropertiesException {
        Iterator i = this.alternatives.iterator();
        while (i.hasNext()) {
            Object value;
            try {
                value = inContext.replace(i.next());
            }
            catch (PropertiesException e) {
                if (!Log.instance().isLoggable(Level.FINE)) continue;
                Log.instance().fine(e.getMessage());
                continue;
            }
            if (value == null) continue;
            if (value instanceof File && !((File)value).exists()) {
                if (!Log.instance().isLoggable(Level.FINE)) continue;
                Log.instance().fine("Properties: " + ((File)value).getAbsolutePath() + " does not exist.");
                continue;
            }
            if (value == Null.INSTANCE || value == NoProperties.INSTANCE) continue;
            return value;
        }
        return null;
    }

    public Replaceable copy(Properties inParent) {
        ArrayList<Object> newAlternatives = new ArrayList<Object>();
        Iterator i = this.alternatives.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (value instanceof Properties) {
                newAlternatives.add(((Properties)value).copy(inParent));
                continue;
            }
            if (value instanceof Replaceable) {
                newAlternatives.add(((Replaceable)value).copy(inParent));
                continue;
            }
            newAlternatives.add(value);
        }
        return new Switch(newAlternatives);
    }
}

