/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Properties;
import com.eva.properties.Replaceable;

class Writer {
    private static final String NEWLINE = "\r\n";
    private StringBuffer buffer = new StringBuffer();
    private StringBuffer indentation = new StringBuffer();

    void write(Object inValue) {
        if (this.buffer.charAt(this.buffer.length() - 1) == '\n') {
            this.appendIndentation();
        }
        if (inValue instanceof Properties) {
            ((Properties)inValue).write(this);
        } else if (inValue instanceof Replaceable) {
            ((Replaceable)inValue).write(this);
        } else if (inValue instanceof String) {
            this.append('\"');
            this.append((String)inValue);
            this.append("\"\n");
        } else {
            this.append(String.valueOf(inValue));
            this.append('\n');
        }
    }

    Writer() {
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void append(String inString) {
        this.buffer.append(inString);
    }

    public void appendIndentation() {
        this.buffer.append(this.indentation);
    }

    public void appendLine(String inLine) {
        this.buffer.append(this.indentation);
        this.buffer.append(inLine);
        this.buffer.append(NEWLINE);
    }

    public void appendNewline() {
        this.buffer.append(NEWLINE);
    }

    public void decreaseIndentation() {
        this.indentation.deleteCharAt(0);
    }

    public void increaseIndentation() {
        this.indentation.append('\t');
    }

    public void append(char inChar) {
        this.buffer.append(inChar);
    }
}

