/*
 * Decompiled with CFR 0.152.
 */
package com.github.ccob.bittrex4j;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.ccob.bittrex4j.ApiKeySecret;
import com.github.ccob.bittrex4j.ConnectionStateChange;
import com.github.ccob.bittrex4j.DateTimeDeserializer;
import com.github.ccob.bittrex4j.EncryptionUtility;
import com.github.ccob.bittrex4j.HttpFactory;
import com.github.ccob.bittrex4j.Observable;
import com.github.ccob.bittrex4j.SignalRLoggerDecorator;
import com.github.ccob.bittrex4j.UrlBuilder;
import com.github.ccob.bittrex4j.Utils;
import com.github.ccob.bittrex4j.cloudflare.CloudFlareAuthorizer;
import com.github.ccob.bittrex4j.dao.Balance;
import com.github.ccob.bittrex4j.dao.CompletedOrder;
import com.github.ccob.bittrex4j.dao.Currency;
import com.github.ccob.bittrex4j.dao.DepositAddress;
import com.github.ccob.bittrex4j.dao.ExchangeSummaryState;
import com.github.ccob.bittrex4j.dao.Market;
import com.github.ccob.bittrex4j.dao.MarketOrdersResult;
import com.github.ccob.bittrex4j.dao.MarketSummary;
import com.github.ccob.bittrex4j.dao.MarketSummaryResult;
import com.github.ccob.bittrex4j.dao.Order;
import com.github.ccob.bittrex4j.dao.Response;
import com.github.ccob.bittrex4j.dao.Tick;
import com.github.ccob.bittrex4j.dao.UpdateExchangeState;
import com.github.ccob.bittrex4j.dao.UuidResult;
import com.github.ccob.bittrex4j.dao.WalletHealthResult;
import com.github.ccob.bittrex4j.dao.WithdrawalDeposit;
import com.github.ccob.bittrex4j.listeners.InvocationResult;
import com.github.ccob.bittrex4j.listeners.Listener;
import com.github.ccob.bittrex4j.listeners.UpdateExchangeStateListener;
import com.github.ccob.bittrex4j.listeners.UpdateSummaryStateListener;
import com.github.signalr4j.client.ConnectionState;
import com.github.signalr4j.client.Platform;
import com.github.signalr4j.client.hubs.HubConnection;
import com.github.signalr4j.client.hubs.HubProxy;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BittrexExchange
implements AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(BittrexExchange.class);
    private static Logger log_sockets = LoggerFactory.getLogger((String)BittrexExchange.class.getName().concat(".WebSockets"));
    private static final String MARKET = "market";
    private static final String MARKETS = "markets";
    private static final String CURRENCY = "currency";
    private static final String CURRENCIES = "currencies";
    private static final String ACCOUNT = "account";
    private static final String PUBLIC = "public";
    private static final List<String> terminalErrors = Arrays.asList("INSUFFICIENT_FUNDS", "APIKEY_INVALID");
    private ApiKeySecret apiKeySecret;
    private ObjectMapper mapper;
    private HttpClient httpClient;
    private HubConnection hubConnection;
    private HubProxy hubProxy;
    private HttpClientContext httpClientContext;
    private HttpFactory httpFactory;
    private List<String> marketSubscriptions = new ArrayList<String>();
    private Observable<UpdateExchangeState> updateExchangeStateBroker = new Observable();
    private Observable<ExchangeSummaryState> exchangeSummaryStateBroker = new Observable();
    private Observable<Throwable> websockerErrorListener = new Observable();
    private Observable<ConnectionStateChange> websocketStateChangeListener = new Observable();
    private Runnable connectedHandler;
    private JavaType updateExchangeStateType;
    private JavaType exchangeSummaryStateType;
    private Timer reconnectTimer = new Timer();
    private int retries;

    public BittrexExchange() throws IOException {
        this(5);
    }

    public BittrexExchange(String apikey, String secret) throws IOException {
        this(5, apikey, secret, new HttpFactory());
    }

    public BittrexExchange(int retries) throws IOException {
        this(retries, null, null);
    }

    public BittrexExchange(int retries, String apikey, String secret) throws IOException {
        this(retries, apikey, secret, new HttpFactory());
    }

    public BittrexExchange(int retries, String apikey, String secret, HttpFactory httpFactory) throws IOException {
        this.apiKeySecret = new ApiKeySecret(apikey, secret);
        this.httpFactory = httpFactory;
        this.retries = retries;
        this.mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        this.mapper.registerModule((Module)module);
        this.updateExchangeStateType = this.mapper.getTypeFactory().constructType(UpdateExchangeState.class);
        this.exchangeSummaryStateType = this.mapper.getTypeFactory().constructType(ExchangeSummaryState.class);
        this.httpClient = httpFactory.createClient();
        this.httpClientContext = httpFactory.createClientContext();
    }

    private void performCloudFlareAuthorization() throws IOException {
        try {
            this.httpClientContext = this.httpFactory.createClientContext();
            CloudFlareAuthorizer cloudFlareAuthorizer = new CloudFlareAuthorizer(this.httpClient, this.httpClientContext);
            cloudFlareAuthorizer.getAuthorizationResult("https://bittrex.com");
        }
        catch (ScriptException e) {
            log.error("Failed to perform CloudFlare authorization", (Throwable)e);
        }
    }

    private void prepareHubConnectionForCloudFlare() {
        String cookies = this.httpClientContext.getCookieStore().getCookies().stream().map(cookie -> String.format("%s=%s", cookie.getName(), cookie.getValue())).collect(Collectors.joining(";"));
        this.hubConnection.getHeaders().put("Cookie", cookies);
        this.hubConnection.getHeaders().put("User-Agent", Platform.getUserAgent());
    }

    @Override
    public void close() throws IOException {
        this.disconnectFromWebSocket();
    }

    public void onUpdateSummaryState(UpdateSummaryStateListener exchangeSummaryState) {
        this.exchangeSummaryStateBroker.addObserver(exchangeSummaryState);
    }

    public void onUpdateExchangeState(UpdateExchangeStateListener listener) {
        this.updateExchangeStateBroker.addObserver(listener);
    }

    public void onWebsocketError(Listener<Throwable> listener) {
        this.websockerErrorListener.addObserver(listener);
    }

    public void onWebsocketStateChange(Listener<ConnectionStateChange> listener) {
        this.websocketStateChangeListener.addObserver(listener);
    }

    private void registerForEvent(String eventName, JavaType deltasType, Observable broker) {
        this.hubProxy.on(eventName, deltas -> {
            try {
                broker.notifyObservers(this.mapper.readerFor(deltasType).readValue(new Gson().toJson(deltas)));
            }
            catch (IOException e) {
                log.error("Failed to parse response", (Throwable)e);
            }
        }, Object.class);
    }

    public void subscribeToExchangeDeltas(String marketName, InvocationResult<Boolean> invocationResult) {
        this.hubProxy.invoke(Boolean.class, "subscribeToExchangeDeltas", new Object[]{marketName}).done(result -> {
            this.marketSubscriptions.add(marketName);
            if (invocationResult != null) {
                invocationResult.complete((Boolean)result);
            }
        });
    }

    public void subscribeToMarketSummaries(InvocationResult<Boolean> invocationResult) {
        this.hubProxy.invoke(Boolean.class, "SubscribeToSummaryDeltas", new Object[0]).done(result -> {
            if (invocationResult != null) {
                invocationResult.complete((Boolean)result);
            }
        });
    }

    public void queryExchangeState(String marketName, UpdateExchangeStateListener updateExchangeStateListener) {
        this.hubProxy.invoke(LinkedTreeMap.class, "queryExchangeState", new Object[]{marketName}).done(exchangeState -> {
            exchangeState.putIfAbsent((Object)"MarketName", (Object)marketName);
            updateExchangeStateListener.onEvent((UpdateExchangeState)this.mapper.readerFor(this.updateExchangeStateType).readValue(new Gson().toJson(exchangeState)));
        });
    }

    public void disconnectFromWebSocket() {
        this.hubConnection.stop();
    }

    private void startConnection() {
        try {
            this.hubConnection = this.httpFactory.createHubConnection("https://socket.bittrex.com", null, true, new SignalRLoggerDecorator(log_sockets));
            this.hubConnection.setReconnectOnError(false);
            this.hubProxy = this.hubConnection.createHubProxy("CoreHub");
            this.hubConnection.connected(this.connectedHandler);
            this.registerForEvent("updateSummaryState", this.exchangeSummaryStateType, this.exchangeSummaryStateBroker);
            this.registerForEvent("updateExchangeState", this.updateExchangeStateType, this.updateExchangeStateBroker);
            this.setupErrorHandler();
            this.setupStateChangeHandler();
            this.performCloudFlareAuthorization();
            this.prepareHubConnectionForCloudFlare();
            this.hubConnection.start();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.error("Failed to perform CloudFlare authorization on startup", (Throwable)e);
            } else {
                log.error("Failed to perform CloudFlare authorization on startup: {}", (Object)e.toString());
            }
            this.reconnectTimer.schedule((TimerTask)new ReconnectTimerTask(), 5000L);
        }
    }

    private void setupErrorHandler() {
        this.hubConnection.error(er -> this.websockerErrorListener.notifyObservers(er));
    }

    private void setupStateChangeHandler() {
        this.hubConnection.stateChanged((oldState, newState) -> {
            if (newState == ConnectionState.Disconnected) {
                this.reconnectTimer.schedule((TimerTask)new ReconnectTimerTask(), 5000L);
            }
            this.websocketStateChangeListener.notifyObservers(new ConnectionStateChange(oldState, newState));
        });
    }

    public void connectToWebSocket(Runnable connectedHandler) throws IOException {
        this.connectedHandler = connectedHandler;
        this.startConnection();
    }

    public Response<Tick[]> getTicks(String market, Interval tickInterval) {
        return this.getResponse((TypeReference)new TypeReference<Response<Tick[]>>(){}, UrlBuilder.v2().withGroup(MARKET).withMethod("getticks").withArgument("marketname", market).withArgument("tickInterval", tickInterval.toString()));
    }

    public Response<Tick[]> getLatestTick(String market, Interval tickInterval) {
        return this.getResponse((TypeReference)new TypeReference<Response<Tick[]>>(){}, UrlBuilder.v2().withGroup(MARKET).withMethod("getlatesttick").withArgument("marketname", market).withArgument("tickInterval", tickInterval.toString()));
    }

    public Response<MarketSummary> getMarketSummary(String market) {
        return this.getResponse((TypeReference)new TypeReference<Response<MarketSummary>>(){}, UrlBuilder.v2().withGroup(MARKET).withMethod("getmarketsummary").withArgument("marketname", market));
    }

    public Response<MarketSummary[]> getMarketSummaryV1(String market) {
        return this.getResponse((TypeReference)new TypeReference<Response<MarketSummary[]>>(){}, UrlBuilder.v1_1().withGroup(PUBLIC).withMethod("getmarketsummary").withArgument(MARKET, market));
    }

    public Response<MarketOrdersResult> getMarketOrderBook(String market) {
        return this.getResponse((TypeReference)new TypeReference<Response<MarketOrdersResult>>(){}, UrlBuilder.v2().withGroup(MARKET).withMethod("getmarketorderbook").withArgument("marketname", market));
    }

    public Response<CompletedOrder[]> getMarketHistory(String market) {
        return this.getResponse((TypeReference)new TypeReference<Response<CompletedOrder[]>>(){}, UrlBuilder.v1_1().withGroup(PUBLIC).withMethod("getmarkethistory").withArgument(MARKET, market));
    }

    public Response<Order[]> getOpenOrders(String market) {
        return this.getOpenOrders(market, this.apiKeySecret);
    }

    public Response<Order[]> getOpenOrders(String market, ApiKeySecret credentials) {
        return this.getResponse((TypeReference)new TypeReference<Response<Order[]>>(){}, UrlBuilder.v1_1().withApiKey(credentials.getKey(), credentials.getSecret()).withGroup(MARKET).withMethod("getopenorders").withArgument("marketname", market));
    }

    public Response<Order[]> getOpenOrders() {
        return this.getOpenOrders(this.apiKeySecret);
    }

    public Response<Order[]> getOpenOrders(ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<Order[]>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(MARKET).withMethod("getopenorders"));
    }

    public Response<MarketSummaryResult[]> getMarketSummaries() {
        return this.getResponse((TypeReference)new TypeReference<Response<MarketSummaryResult[]>>(){}, UrlBuilder.v2().withGroup(MARKETS).withMethod("getmarketsummaries"));
    }

    public Response<Market[]> getMarkets() {
        return this.getResponse((TypeReference)new TypeReference<Response<Market[]>>(){}, UrlBuilder.v1_1().withGroup(PUBLIC).withMethod("getmarkets"));
    }

    public Response<Currency[]> getCurrencies() {
        return this.getResponse((TypeReference)new TypeReference<Response<Currency[]>>(){}, UrlBuilder.v2().withGroup(CURRENCIES).withMethod("getcurrenices"));
    }

    public Response<WalletHealthResult[]> getWalletHealth() {
        return this.getResponse((TypeReference)new TypeReference<Response<WalletHealthResult[]>>(){}, UrlBuilder.v2().withGroup(CURRENCIES).withMethod("getwallethealth"));
    }

    public Response<Order[]> getOrderHistory(String market) {
        return this.getOrderHistory(market, this.apiKeySecret);
    }

    public Response<Order[]> getOrderHistory(String market, ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<Order[]>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(ACCOUNT).withMethod("getorderhistory").withArgument(MARKET, market));
    }

    public Response<Balance[]> getBalances() {
        return this.getBalances(this.apiKeySecret);
    }

    public Response<Balance[]> getBalances(ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<Balance[]>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(ACCOUNT).withMethod("getbalances"));
    }

    public Response<Balance> getBalance(String currency) {
        return this.getBalance(currency, this.apiKeySecret);
    }

    public Response<Balance> getBalance(String currency, ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<Balance>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(ACCOUNT).withMethod("getbalance").withArgument(CURRENCY, currency));
    }

    public Response<Order> getOrder(String uuid) {
        return this.getOrder(uuid, this.apiKeySecret);
    }

    public Response<Order> getOrder(String uuid, ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<Order>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(ACCOUNT).withMethod("getorder").withArgument("uuid", uuid));
    }

    public Response<DepositAddress> getDepositAddress(String currency) {
        return this.getDepositAddress(currency, this.apiKeySecret);
    }

    public Response<DepositAddress> getDepositAddress(String currency, ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<DepositAddress>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(ACCOUNT).withMethod("getdepositaddress").withArgument(CURRENCY, currency));
    }

    public Response<WithdrawalDeposit[]> getWithdrawalHistory(String currency) {
        return this.getWithdrawalHistory(currency, this.apiKeySecret);
    }

    public Response<WithdrawalDeposit[]> getWithdrawalHistory(String currency, ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<WithdrawalDeposit[]>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(ACCOUNT).withMethod("getwithdrawalhistory").withArgument(CURRENCY, currency));
    }

    public Response<WithdrawalDeposit[]> getDepositHistory(String currency) {
        return this.getDepositHistory(currency, this.apiKeySecret);
    }

    public Response<WithdrawalDeposit[]> getDepositHistory(String currency, ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<WithdrawalDeposit[]>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(ACCOUNT).withMethod("getdeposithistory").withArgument(CURRENCY, currency));
    }

    public Response<UuidResult> withdraw(String currency, double quantity, String address) {
        return this.withdraw(currency, quantity, address, this.apiKeySecret);
    }

    public Response<UuidResult> withdraw(String currency, double quantity, String address, ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<UuidResult>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(ACCOUNT).withMethod("withdraw").withArgument(CURRENCY, currency).withArgument("quantity", BigDecimal.valueOf(quantity).toString()).withArgument("address", address));
    }

    public Response<UuidResult> buyLimit(String market, double quantity, double rate) {
        return this.buyLimit(market, quantity, rate, this.apiKeySecret);
    }

    public Response<UuidResult> buyLimit(String market, double quantity, double rate, ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<UuidResult>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(MARKET).withMethod("buylimit").withArgument(MARKET, market).withArgument("quantity", Double.toString(quantity)).withArgument("rate", Double.toString(rate)));
    }

    public Response<UuidResult> sellLimit(String market, double quantity, double rate) {
        return this.sellLimit(market, quantity, rate, this.apiKeySecret);
    }

    public Response<UuidResult> sellLimit(String market, double quantity, double rate, ApiKeySecret apiKeySecret) {
        return this.getResponse((TypeReference)new TypeReference<Response<UuidResult>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(MARKET).withMethod("selllimit").withArgument(MARKET, market).withArgument("quantity", Double.toString(quantity)).withArgument("rate", Double.toString(rate)));
    }

    public Response<?> cancel(String orderUuid) {
        return this.cancel(orderUuid, this.apiKeySecret);
    }

    public Response<?> cancel(String orderUuid, ApiKeySecret apiKeySecret) {
        return this.getResponse(new TypeReference<Response<?>>(){}, UrlBuilder.v1_1().withApiKey(apiKeySecret.getKey(), apiKeySecret.getSecret()).withGroup(MARKET).withMethod("cancel").withArgument("uuid", orderUuid));
    }

    private boolean isTerminalError(String message) {
        return terminalErrors.contains(message);
    }

    private <Result> Response<Result> getResponse(TypeReference resultType, UrlBuilder urlBuilder) {
        int triesLeft = this.retries;
        Response<Result> result = this.getResponseBody(resultType, urlBuilder);
        while (!result.isSuccess() && triesLeft-- > 0 && !this.isTerminalError(result.getMessage())) {
            log.warn("Request to URL {} failed with error {}, retries left: {}", new Object[]{urlBuilder.build(), result.getMessage(), triesLeft});
            result = this.getResponseBody(resultType, urlBuilder);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!result.isSuccess()) {
            log.warn("Request to URL {} failed with error {}", (Object)urlBuilder.build(), (Object)result.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Result> Response<Result> getResponseBody(TypeReference resultType, UrlBuilder urlBuilder) {
        CloseableHttpResponse httpResponse = null;
        try {
            HttpGet request;
            if (urlBuilder.isSecure()) {
                ApiKeySecret builderApiSecret = urlBuilder.getApiKeySecret();
                urlBuilder.withArgument("nonce", EncryptionUtility.generateNonce());
                String url = urlBuilder.build();
                request = new HttpGet(url);
                request.addHeader("apisign", EncryptionUtility.calculateHash(builderApiSecret.getSecret(), url, "HmacSHA512"));
            } else {
                request = new HttpGet(urlBuilder.build());
            }
            request.addHeader("accept", "application/json");
            int hardTimeout = 60;
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    request.abort();
                }
            };
            new Timer(true).schedule(task, hardTimeout * 1000);
            log.debug("Executing HTTP request: {}", (Object)request.toString());
            httpResponse = (CloseableHttpResponse)this.httpClient.execute((HttpUriRequest)request, (HttpContext)this.httpClientContext);
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                String json = Utils.convertStreamToString(httpResponse.getEntity().getContent());
                log.trace("REST JSON result: {}", (Object)json);
                task.cancel();
                Response response = (Response)this.mapper.readerFor(resultType).readValue(json);
                return response;
            }
            log.warn("HTTP request failed with error code {} and reason {}", (Object)responseCode, (Object)httpResponse.getStatusLine().getReasonPhrase());
            task.cancel();
            Response<Object> response = new Response<Object>(false, httpResponse.getStatusLine().getReasonPhrase(), null);
            return response;
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            Response<Object> response = new Response<Object>(false, e.getMessage(), null);
            return response;
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.getEntity().getContent().close();
                    httpResponse.close();
                }
                catch (IOException e) {
                    log.debug("Failed to cleanup HttpResponse", (Throwable)e);
                }
            }
        }
    }

    private class ReconnectTimerTask
    extends TimerTask {
        private ReconnectTimerTask() {
        }

        @Override
        public void run() {
            log.info("Attempting to reconnect to web socket");
            BittrexExchange.this.startConnection();
        }
    }

    public static enum Interval {
        oneMin,
        fiveMin,
        thirtyMin,
        hour,
        day;

    }
}

