/*
 * Decompiled with CFR 0.152.
 */
package com.github.ccob.bittrex4j;

import com.github.ccob.bittrex4j.ApiKeySecret;
import java.util.HashMap;
import java.util.Map;

public class UrlBuilder {
    private static final String API_VERSION_2 = "v2.0";
    private static final String API_VERSION_1_1 = "v1.1";
    private static final String INITIAL_URL = "https://bittrex.com/api/";
    private String baseUrl;
    private String method;
    private String group;
    private Map<String, String> arguments = new HashMap<String, String>();
    private String apiKey;
    private String apiSecret;
    boolean isV2;

    static UrlBuilder v1_1() {
        return new UrlBuilder("https://bittrex.com/api/v1.1", false);
    }

    static UrlBuilder v2() {
        return new UrlBuilder("https://bittrex.com/api/v2.0", true);
    }

    private UrlBuilder(String initialUrl, boolean isV2) {
        this.baseUrl = initialUrl;
        this.isV2 = isV2;
    }

    UrlBuilder withGroup(String group) {
        this.group = group;
        return this;
    }

    UrlBuilder withArgument(String name, String value) {
        this.arguments.put(name, value);
        return this;
    }

    UrlBuilder withApiKey(String apiKey, String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.withArgument("apikey", apiKey);
        return this;
    }

    UrlBuilder withMethod(String method) {
        this.method = method;
        return this;
    }

    boolean isSecure() {
        return this.apiKey != null && this.apiSecret != null;
    }

    ApiKeySecret getApiKeySecret() {
        return new ApiKeySecret(this.apiKey, this.apiSecret);
    }

    String build() {
        String result = this.baseUrl;
        if (this.isV2) {
            if (this.isSecure()) {
                throw new UnsupportedOperationException("v2 secure API currently not supported");
            }
            result = result + "/pub";
        }
        result = result + "/" + this.group;
        result = result + "/" + this.method;
        if (!this.arguments.isEmpty()) {
            result = result + "?";
            for (String name : this.arguments.keySet()) {
                result = result + name + "=" + this.arguments.get(name) + "&";
            }
        }
        return result;
    }
}

