/*
 * Decompiled with CFR 0.152.
 */
package com.github.ccob.bittrex4j.cloudflare;

import com.github.ccob.bittrex4j.PatternStreamer;
import com.github.ccob.bittrex4j.Utils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudFlareAuthorizer {
    private static Logger log = LoggerFactory.getLogger(CloudFlareAuthorizer.class);
    private HttpClient httpClient;
    private HttpClientContext httpClientContext;
    private Pattern jsChallenge = Pattern.compile("name=\"jschl_vc\" value=\"(.+?)\"");
    private Pattern password = Pattern.compile("name=\"pass\" value=\"(.+?)\"");
    private Pattern jsScript = Pattern.compile("var s,t,o,p,b,r,e,a,k,i,n,g,f, (.+?)=\\{\"(.+?)\"");
    private ScriptEngineManager engineManager = new ScriptEngineManager();
    private ScriptEngine engine = this.engineManager.getEngineByName("nashorn");

    public CloudFlareAuthorizer(HttpClient httpClient, HttpClientContext httpClientContext) {
        this.httpClient = httpClient;
        this.httpClientContext = httpClientContext;
    }

    public void getAuthorizationResult(String url) throws IOException, ScriptException {
        URL cloudFlareUrl = new URL(url);
        try {
            int retries = 5;
            int timer = 5000;
            Response response = this.getResponse(url, null);
            while (response.httpStatus == 503 && retries-- > 0) {
                String answer = this.getJsAnswer(cloudFlareUrl, response.responseText);
                String jschl_vc = new PatternStreamer(this.jsChallenge).results(response.responseText).findFirst().orElse("");
                String pass = new PatternStreamer(this.password).results(response.responseText).findFirst().orElse("");
                String authUrl = String.format("https://%s/cdn-cgi/l/chk_jschl?jschl_vc=%s&pass=%s&jschl_answer=%s", cloudFlareUrl.getHost(), URLEncoder.encode(jschl_vc, "UTF-8"), URLEncoder.encode(pass, "UTF-8"), answer);
                Thread.sleep(timer += 1500);
                response = this.getResponse(authUrl, url);
            }
            if (response.httpStatus != 200) {
                log.error("Failed to perform Cloudflare DDoS authorization, got status {}", (Object)response.httpStatus);
                return;
            }
        }
        catch (InterruptedException ie) {
            log.error("Interrupted whilst waiting to perform CloudFlare authorization", (Throwable)ie);
            return;
        }
        Optional<Cookie> cfClearanceCookie = this.httpClientContext.getCookieStore().getCookies().stream().filter(cookie -> cookie.getName().equals("cf_clearance")).findFirst();
        if (cfClearanceCookie.isPresent()) {
            log.info("Cloudflare DDos authorization success, cf_clearance: {}", (Object)cfClearanceCookie.get().getValue());
        } else {
            log.info("Cloudflare DDoS is not currently active");
        }
    }

    private Response getResponse(String url, String referer) throws IOException {
        final HttpGet getRequest = new HttpGet(url);
        if (referer != null) {
            getRequest.setHeader("Referer", referer);
        }
        int hardTimeout = 30;
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                getRequest.abort();
            }
        };
        new Timer(true).schedule(task, hardTimeout * 1000);
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getRequest, (HttpContext)this.httpClientContext);
        String responseText = Utils.convertStreamToString(httpResponse.getEntity().getContent());
        int httpStatus = httpResponse.getStatusLine().getStatusCode();
        task.cancel();
        httpResponse.getEntity().getContent().close();
        ((CloseableHttpResponse)httpResponse).close();
        return new Response(httpStatus, responseText);
    }

    private String getJsAnswer(URL url, String responseHtml) throws ScriptException, MalformedURLException {
        BigDecimal answer = new BigDecimal(0);
        Matcher result = this.jsScript.matcher(responseHtml);
        if (result.find()) {
            String val1 = result.group(1);
            String val2 = result.group(2);
            Matcher matcher1 = Pattern.compile(val1 + "=\\{\"" + val2 + "\":(.+?)}").matcher(responseHtml);
            if (matcher1.find()) {
                String jsCode = String.format("a=%s;%s", matcher1.group(1), new PatternStreamer(val1 + "\\." + val2 + "([^.,].+?);").results(responseHtml).collect(Collectors.joining(";a", "a", ";")));
                answer = new BigDecimal(this.engine.eval(jsCode).toString()).setScale(10, 4);
                answer = answer.add(new BigDecimal(url.getHost().length()));
            }
        }
        return answer.toString();
    }

    private static class Response {
        private int httpStatus;
        private String responseText;

        Response(int httpStatus, String responseText) {
            this.httpStatus = httpStatus;
            this.responseText = responseText;
        }
    }
}

