/*
 * Decompiled with CFR 0.152.
 */
package com.github.ccob.bittrex4j.dao;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;

public class Fill {
    Long id;
    String orderType;
    String fillType;
    double price;
    double quantity;
    double total;
    ZonedDateTime timeStamp;

    @JsonCreator
    public Fill(@Nullable @JsonProperty(value="Id") Long id, @JsonProperty(value="OrderType") String orderType, @Nullable @JsonProperty(value="FillType") String fillType, @Nullable @JsonProperty(value="Price") Double price, @Nullable @JsonProperty(value="Rate") Double rate, @JsonProperty(value="Quantity") double quantity, @Nullable @JsonProperty(value="Total") Double total, @JsonProperty(value="TimeStamp") ZonedDateTime timeStamp) {
        if (rate == null && price == null) {
            throw new IllegalArgumentException("Either rate or price should be set");
        }
        this.id = id;
        this.orderType = orderType;
        this.quantity = quantity;
        this.timeStamp = timeStamp;
        if (price != null) {
            this.price = price;
        }
        if (rate != null) {
            if (price != null) {
                throw new IllegalArgumentException("Both rate and price cannot be set at the same time");
            }
            this.price = rate;
        }
        this.total = total != null ? total : this.price * this.quantity;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public double getPrice() {
        return this.price;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public ZonedDateTime getTimeStamp() {
        return this.timeStamp;
    }

    public double getTotal() {
        return this.total;
    }

    @Nullable
    public String getFillType() {
        return this.fillType;
    }
}

