/*
 * Decompiled with CFR 0.152.
 */
package com.github.ccob.bittrex4j.dao;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.ccob.bittrex4j.DateTimeDeserializer;
import java.math.BigDecimal;
import java.time.ZonedDateTime;

@JsonIgnoreProperties(value={"DisplayMarketName"})
public class MarketSummary {
    @JsonProperty(value="MarketName")
    String marketName;
    @JsonProperty(value="High")
    BigDecimal high;
    @JsonProperty(value="Low")
    BigDecimal low;
    @JsonProperty(value="Volume")
    BigDecimal volume;
    @JsonProperty(value="Last")
    BigDecimal last;
    @JsonProperty(value="BaseVolume")
    BigDecimal baseVolume;
    @JsonProperty(value="TimeStamp")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    ZonedDateTime timeStamp;
    @JsonProperty(value="Bid")
    BigDecimal bid;
    @JsonProperty(value="Ask")
    BigDecimal ask;
    @JsonProperty(value="OpenBuyOrders")
    int openBuyOrders;
    @JsonProperty(value="OpenSellOrders")
    int openSellOrders;
    @JsonProperty(value="PrevDay")
    BigDecimal prevDay;
    @JsonProperty(value="Created")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    ZonedDateTime created;

    public MarketSummary() {
    }

    public MarketSummary(BigDecimal bid, BigDecimal ask) {
        this.bid = bid;
        this.ask = ask;
    }

    public String getMarketName() {
        return this.marketName;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public BigDecimal getBaseVolume() {
        return this.baseVolume;
    }

    public ZonedDateTime getTimeStamp() {
        return this.timeStamp;
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public int getOpenBuyOrders() {
        return this.openBuyOrders;
    }

    public int getOpenSellOrders() {
        return this.openSellOrders;
    }

    public BigDecimal getPrevDay() {
        return this.prevDay;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }
}

