/*
 * Decompiled with CFR 0.152.
 */
package com.github.ccob.bittrex4j.dao;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;

@JsonIgnoreProperties(value={"Uuid"})
public class Order {
    private String accountId;
    private String orderUuid;
    private String exchange;
    private String type;
    private double quantity;
    private double quantityRemaining;
    private double limit;
    private double reserved;
    private double reserveRemaining;
    private double commissionReserved;
    private double commissionReserveRemaining;
    private double commissionPaid;
    private double price;
    private double pricePerUnit;
    private ZonedDateTime opened;
    private ZonedDateTime closed;
    private boolean open;
    private String sentinel;
    private boolean cancelInitiated;
    private boolean immediateOrCancel;
    private boolean conditional;
    private String condition;
    private String conditionTarget;

    @JsonCreator
    public Order(@JsonProperty(value="AccountId") String accountId, @JsonProperty(value="OrderUuid") String orderUuid, @JsonProperty(value="Exchange") String exchange, @JsonProperty(value="Type") @JsonAlias(value={"OrderType"}) String type, @JsonProperty(value="Quantity") double quantity, @JsonProperty(value="QuantityRemaining") double quantityRemaining, @JsonProperty(value="Limit") double limit, @JsonProperty(value="Reserved") double reserved, @JsonProperty(value="ReserveRemaining") double reserveRemaining, @JsonProperty(value="CommissionReserved") double commissionReserved, @JsonProperty(value="CommissionReserveRemaining") double commissionReserveRemaining, @JsonProperty(value="CommissionPaid") @JsonAlias(value={"Commission"}) double commissionPaid, @JsonProperty(value="Price") double price, @JsonProperty(value="PricePerUnit") double pricePerUnit, @JsonProperty(value="Opened") @JsonAlias(value={"TimeStamp"}) ZonedDateTime opened, @JsonProperty(value="Closed") ZonedDateTime closed, @JsonProperty(value="IsOpen") boolean open, @JsonProperty(value="Sentinel") String sentinel, @JsonProperty(value="CancelInitiated") boolean cancelInitiated, @JsonProperty(value="ImmediateOrCancel") boolean immediateOrCancel, @JsonProperty(value="IsConditional") boolean conditional, @JsonProperty(value="Condition") String condition, @JsonProperty(value="ConditionTarget") String conditionTarget) {
        this.accountId = accountId;
        this.orderUuid = orderUuid;
        this.exchange = exchange;
        this.type = type;
        this.quantity = quantity;
        this.quantityRemaining = quantityRemaining;
        this.limit = limit;
        this.reserved = reserved;
        this.reserveRemaining = reserveRemaining;
        this.commissionReserved = commissionReserved;
        this.commissionReserveRemaining = commissionReserveRemaining;
        this.commissionPaid = commissionPaid;
        this.price = price;
        this.pricePerUnit = pricePerUnit;
        this.opened = opened;
        this.closed = closed;
        this.open = open;
        this.sentinel = sentinel;
        this.cancelInitiated = cancelInitiated;
        this.immediateOrCancel = immediateOrCancel;
        this.conditional = conditional;
        this.condition = condition;
        this.conditionTarget = conditionTarget;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getOrderUuid() {
        return this.orderUuid;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getType() {
        return this.type;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public double getQuantityRemaining() {
        return this.quantityRemaining;
    }

    public double getLimit() {
        return this.limit;
    }

    public double getReserved() {
        return this.reserved;
    }

    public double getReserveRemaining() {
        return this.reserveRemaining;
    }

    public double getCommissionReserved() {
        return this.commissionReserved;
    }

    public double getCommissionReserveRemaining() {
        return this.commissionReserveRemaining;
    }

    public double getCommissionPaid() {
        return this.commissionPaid;
    }

    public double getPrice() {
        return this.price;
    }

    public double getPricePerUnit() {
        return this.pricePerUnit;
    }

    public ZonedDateTime getOpened() {
        return this.opened;
    }

    public ZonedDateTime getClosed() {
        return this.closed;
    }

    public boolean isOpen() {
        return this.open || this.closed == null;
    }

    public String getSentinel() {
        return this.sentinel;
    }

    public boolean isCancelInitiated() {
        return this.cancelInitiated;
    }

    public boolean isImmediateOrCancel() {
        return this.immediateOrCancel;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getConditionTarget() {
        return this.conditionTarget;
    }
}

