/*
 * Decompiled with CFR 0.152.
 */
package com.gkatzioura.maven.cloud.s3;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.gkatzioura.maven.cloud.resolver.KeyResolver;
import com.gkatzioura.maven.cloud.s3.EndpointProperty;
import com.gkatzioura.maven.cloud.s3.PathStyleEnabledProperty;
import com.gkatzioura.maven.cloud.s3.PublicReadProperty;
import com.gkatzioura.maven.cloud.s3.S3StorageRepository;
import com.gkatzioura.maven.cloud.transfer.TransferProgress;
import com.gkatzioura.maven.cloud.transfer.TransferProgressImpl;
import com.gkatzioura.maven.cloud.wagon.AbstractStorageWagon;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;

public class S3StorageWagon
extends AbstractStorageWagon {
    private S3StorageRepository s3StorageRepository;
    private final KeyResolver keyResolver = new KeyResolver();
    private String region;
    private Boolean publicRepository;
    private static final Logger LOGGER = Logger.getLogger(S3StorageWagon.class.getName());
    private String endpoint;
    private String pathStyleEnabled;

    public void get(String resourceName, File file) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.transferListenerContainer.fireTransferInitiated(resource, 5);
        this.transferListenerContainer.fireTransferStarted(resource, 5, file);
        TransferProgressImpl transferProgress = new TransferProgressImpl(resource, 5, this.transferListenerContainer);
        try {
            this.s3StorageRepository.copy(resourceName, file, (TransferProgress)transferProgress);
            this.transferListenerContainer.fireTransferCompleted(resource, 5);
        }
        catch (Exception e) {
            this.transferListenerContainer.fireTransferError(resource, 5, e);
            throw e;
        }
    }

    public void put(File file, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        LOGGER.log(Level.FINER, String.format("Uploading file %s to %s", file.getAbsolutePath(), resourceName));
        this.transferListenerContainer.fireTransferInitiated(resource, 6);
        this.transferListenerContainer.fireTransferStarted(resource, 6, file);
        TransferProgressImpl transferProgress = new TransferProgressImpl(resource, 6, this.transferListenerContainer);
        try {
            this.s3StorageRepository.put(file, resourceName, (TransferProgress)transferProgress);
            this.transferListenerContainer.fireTransferCompleted(resource, 6);
        }
        catch (TransferFailedException e) {
            this.transferListenerContainer.fireTransferError(resource, 6, (Exception)((Object)e));
            throw e;
        }
    }

    public boolean getIfNewer(String resourceName, File file, long timeStamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (this.s3StorageRepository.newResourceAvailable(resourceName, timeStamp)) {
            this.get(resourceName, file);
            return true;
        }
        return false;
    }

    public void putDirectory(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Collection allFiles = FileUtils.listFiles((File)source, null, (boolean)true);
        String relativeDestination = destination;
        if (destination != null && destination.startsWith(".")) {
            relativeDestination = destination.length() == 1 ? "" : destination.substring(1);
        }
        for (File file : allFiles) {
            String relativePath = PathUtils.toRelative((File)source, (String)file.getAbsolutePath());
            this.put(file, relativeDestination + "/" + relativePath);
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        return this.s3StorageRepository.exists(resourceName);
    }

    public List<String> getFileList(String s) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            List<String> list = this.s3StorageRepository.list(s);
            list = this.convertS3ListToMavenFileList(list, s);
            if (list.isEmpty()) {
                throw new ResourceDoesNotExistException(s);
            }
            return list;
        }
        catch (AmazonS3Exception e) {
            throw new TransferFailedException("Could not fetch objects for prefix " + s);
        }
    }

    private List<String> convertS3ListToMavenFileList(List<String> list, String path) {
        String prefix = this.keyResolver.resolve(new String[]{this.s3StorageRepository.getBaseDirectory(), path});
        HashSet folders = new HashSet();
        List<String> result = list.stream().map(key -> {
            String filePath = key;
            if (prefix != null && prefix.length() > 0) {
                filePath = key.substring(prefix.length() + 1);
            }
            this.extractFolders(folders, filePath);
            return filePath;
        }).collect(Collectors.toList());
        result.addAll(folders);
        return result;
    }

    private void extractFolders(Set<String> folders, String filePath) {
        if (filePath.contains("/")) {
            String folder = filePath.substring(0, filePath.lastIndexOf(47));
            folders.add(folder + '/');
            if (folder.contains("/")) {
                this.extractFolders(folders, folder);
            }
        } else {
            folders.add(filePath);
        }
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.repository = repository;
        this.sessionListenerContainer.fireSessionOpening();
        String bucket = this.accountResolver.resolve(repository);
        String directory = this.containerResolver.resolve(repository);
        LOGGER.log(Level.FINER, String.format("Opening connection for bucket %s and directory %s", bucket, directory));
        this.s3StorageRepository = new S3StorageRepository(bucket, directory, new PublicReadProperty(this.publicRepository));
        this.s3StorageRepository.connect(authenticationInfo, this.region, new EndpointProperty(this.endpoint), new PathStyleEnabledProperty(this.pathStyleEnabled));
        this.sessionListenerContainer.fireSessionLoggedIn();
        this.sessionListenerContainer.fireSessionOpened();
    }

    public void disconnect() throws ConnectionException {
        this.sessionListenerContainer.fireSessionDisconnecting();
        this.s3StorageRepository.disconnect();
        this.sessionListenerContainer.fireSessionLoggedOff();
        this.sessionListenerContainer.fireSessionDisconnected();
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Boolean getPublicRepository() {
        return this.publicRepository;
    }

    public void setPublicRepository(Boolean publicRepository) {
        this.publicRepository = publicRepository;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getPathStyleAccessEnabled() {
        return this.pathStyleEnabled;
    }

    public void setPathStyleAccessEnabled(String pathStyleEnabled) {
        this.pathStyleEnabled = pathStyleEnabled;
    }
}

