/*
 * Decompiled with CFR 0.152.
 */
package com.gkatzioura.maven.cloud.s3.plugin;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class PrefixKeysIterator
implements Iterator<String> {
    private AmazonS3 amazonS3;
    private String prefix;
    private String bucket;
    private ObjectListing tempListing = null;
    private List<S3ObjectSummary> currentKeys = new ArrayList<S3ObjectSummary>();

    public PrefixKeysIterator(AmazonS3 amazonS3, String bucket, String prefix) {
        this.amazonS3 = amazonS3;
        this.bucket = bucket;
        this.prefix = prefix;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEachRemaining(Consumer<? super String> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.currentKeys.size() > 0) {
            return true;
        }
        this.fetchKeysIfExist();
        return this.currentKeys.size() > 0;
    }

    private void fetchKeysIfExist() {
        if (this.tempListing == null) {
            this.tempListing = this.getObjectListing();
            this.currentKeys.addAll(this.tempListing.getObjectSummaries());
        } else if (this.tempListing.isTruncated()) {
            this.tempListing = this.amazonS3.listNextBatchOfObjects(this.tempListing);
            this.currentKeys.addAll(this.tempListing.getObjectSummaries());
        }
    }

    private ObjectListing getObjectListing() {
        return this.amazonS3.listObjects(new ListObjectsRequest().withBucketName(this.bucket).withPrefix(this.prefix));
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            return null;
        }
        return this.currentKeys.remove(0).getKey();
    }
}

