/*
 * Decompiled with CFR 0.152.
 */
package com.gkatzioura.maven.cloud.s3.plugin.download;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.gkatzioura.maven.cloud.KeyIteratorConcated;
import com.gkatzioura.maven.cloud.s3.plugin.PrefixKeysIterator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="s3-download")
public class S3DownloadMojo
extends AbstractMojo {
    @Parameter(property="s3-download.bucket")
    private String bucket;
    @Parameter(property="s3-download.keys")
    private List<String> keys;
    @Parameter(property="s3-download.downloadPath")
    private String downloadPath;
    private static final String DIRECTORY_CONTENT_TYPE = "application/x-directory";
    private static final Logger LOGGER = Logger.getLogger(S3DownloadMojo.class.getName());

    public S3DownloadMojo() {
    }

    public S3DownloadMojo(String bucket, List<String> keys, String downloadPath) {
        this.bucket = bucket;
        this.keys = keys;
        this.downloadPath = downloadPath;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        AmazonS3 amazonS3 = AmazonS3ClientBuilder.defaultClient();
        if (this.keys.size() == 1) {
            this.downloadSingleFile(amazonS3, this.keys.get(0));
            return;
        }
        List prefixKeysIterators = this.keys.stream().map(pi -> new PrefixKeysIterator(amazonS3, this.bucket, (String)pi)).collect(Collectors.toList());
        KeyIteratorConcated keyIteratorConcated = new KeyIteratorConcated(prefixKeysIterators);
        while (keyIteratorConcated.hasNext()) {
            String key = (String)keyIteratorConcated.next();
            this.downloadFile(amazonS3, key);
        }
    }

    private void downloadSingleFile(AmazonS3 amazonS3, String key) {
        File file = new File(this.downloadPath);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        S3Object s3Object = amazonS3.getObject(this.bucket, key);
        try (S3ObjectInputStream s3ObjectInputStream = s3Object.getObjectContent();
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            IOUtils.copy((InputStream)s3ObjectInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not download s3 file");
            e.printStackTrace();
        }
    }

    private void downloadFile(AmazonS3 amazonS3, String key) {
        S3Object s3Object;
        File file = new File(this.createFullFilePath(key));
        if (file.getParent() != null) {
            file.getParentFile().mkdirs();
        }
        if (this.isDirectory(s3Object = amazonS3.getObject(this.bucket, key))) {
            return;
        }
        try (S3ObjectInputStream s3ObjectInputStream = s3Object.getObjectContent();
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            IOUtils.copy((InputStream)s3ObjectInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not download s3 file");
            e.printStackTrace();
        }
    }

    private final String createFullFilePath(String key) {
        String fullPath = this.downloadPath + "/" + key;
        return fullPath;
    }

    private final boolean isDirectory(S3Object s3Object) {
        return s3Object.getObjectMetadata().getContentType().equals(DIRECTORY_CONTENT_TYPE);
    }
}

