/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.down.plugins;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;

public class NestedEventLoopInvoker {
    private static final Logger LOG = Logger.getLogger(NestedEventLoopInvoker.class.getName());
    private static Method enterNestedEventLoopMethod = null;
    private static Method exitNestedEventLoopMethod = null;
    private static Object invokeObj;

    public static void enterNestedEventLoop(Object key) {
        if (enterNestedEventLoopMethod != null) {
            try {
                enterNestedEventLoopMethod.invoke(invokeObj, key);
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.SEVERE, "Could not enter nested event loop.", e);
            }
            catch (InvocationTargetException e) {
                LOG.log(Level.SEVERE, "Could not enter nested event loop.", e);
            }
        }
    }

    public static void exitNestedEventLoop(Object key, Object rval) {
        if (exitNestedEventLoopMethod != null) {
            try {
                exitNestedEventLoopMethod.invoke(invokeObj, key, rval);
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.SEVERE, "Could not exit nested event loop.", e);
            }
            catch (InvocationTargetException e) {
                LOG.log(Level.SEVERE, "Could not exit nested event loop.", e);
            }
        }
    }

    private static void log(String message, Throwable cause) {
        LOG.log(Level.FINE, message);
        if (LOG.isLoggable(Level.FINE)) {
            cause.printStackTrace();
        }
    }

    static {
        try {
            enterNestedEventLoopMethod = Platform.class.getMethod("enterNestedEventLoop", Object.class);
            exitNestedEventLoopMethod = Platform.class.getMethod("exitNestedEventLoop", Object.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            NestedEventLoopInvoker.log("Could not find method enter/exitNestedEventLoop on javafx.application.Platform", e);
        }
        catch (SecurityException e) {
            NestedEventLoopInvoker.log("Could not find method enter/exitNestedEventLoop on javafx.application.Platform", e);
        }
        if (enterNestedEventLoopMethod == null || exitNestedEventLoopMethod == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.sun.javafx.tk.Toolkit");
            }
            catch (ClassNotFoundException e) {
                NestedEventLoopInvoker.log("Could not find class com.sun.javafx.tk.Toolkit", e);
            }
            if (clazz != null) {
                try {
                    enterNestedEventLoopMethod = clazz.getMethod("enterNestedEventLoop", Object.class);
                    exitNestedEventLoopMethod = clazz.getMethod("exitNestedEventLoop", Object.class, Object.class);
                }
                catch (NoSuchMethodException e) {
                    NestedEventLoopInvoker.log("Could not find method enter/exitNestedEventLoop on com.sun.javafx.tk.Toolkit", e);
                }
                catch (SecurityException e) {
                    NestedEventLoopInvoker.log("Could not find method enter/exitNestedEventLoop on com.sun.javafx.tk.Toolkit", e);
                }
                if (enterNestedEventLoopMethod != null && exitNestedEventLoopMethod != null) {
                    try {
                        Method getToolkitMethod = clazz.getMethod("getToolkit", new Class[0]);
                        invokeObj = getToolkitMethod.invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        NestedEventLoopInvoker.log("Could not get toolkit from com.sun.javafx.fx.Toolkit", e);
                    }
                    catch (IllegalAccessException e) {
                        NestedEventLoopInvoker.log("Could not get toolkit from com.sun.javafx.fx.Toolkit", e);
                    }
                    catch (InvocationTargetException e) {
                        NestedEventLoopInvoker.log("Could not get toolkit from com.sun.javafx.fx.Toolkit", e);
                    }
                }
            }
        }
        if (enterNestedEventLoopMethod == null) {
            LOG.log(Level.SEVERE, "Failed to detect valid enterNestedEventLoop method. Set log level for this logger to FINE for more details.");
        }
        if (exitNestedEventLoopMethod == null) {
            LOG.log(Level.SEVERE, "Failed to detect valid exitNestedEventLoop method. Set log level for this logger to FINE for more details.");
        }
    }
}

