/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.down.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyWatcher {
    private static final int THREAD_SLEEP_DURATION = 5000;
    private static final List<Runnable> PROPERTY_WATCHERS = new ArrayList<Runnable>();
    private static boolean running = false;
    private static Thread watcherThread;

    private PropertyWatcher() {
    }

    public static void addPropertyWatcher(Runnable r) {
        r.run();
        PROPERTY_WATCHERS.add(r);
        PropertyWatcher.updateState();
    }

    public static void removePropertyWatcher(Runnable r) {
        PROPERTY_WATCHERS.remove(r);
        PropertyWatcher.updateState();
    }

    private static void updateState() {
        if (PROPERTY_WATCHERS.isEmpty()) {
            PropertyWatcher.stopThread();
        } else if (!running) {
            PropertyWatcher.startThread();
        }
    }

    private static void startThread() {
        running = true;
        if (watcherThread == null) {
            watcherThread = new Thread(() -> {
                while (running) {
                    for (Runnable r : PROPERTY_WATCHERS) {
                        r.run();
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PropertyWatcher.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                watcherThread = null;
            });
            watcherThread.setDaemon(true);
            watcherThread.start();
        }
    }

    private static void stopThread() {
        running = false;
    }
}

