/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.subscriptions;

import com.google.api.client.googleapis.subscriptions.NotificationCallback;
import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Objects;
import com.google.api.client.util.Preconditions;
import java.io.Serializable;
import java.util.UUID;

@Beta
public final class StoredSubscription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final NotificationCallback notificationCallback;
    private String clientToken;
    private String expiration;
    private final String id;
    private String topicId;

    public StoredSubscription(NotificationCallback notificationCallback) {
        this(notificationCallback, StoredSubscription.randomId());
    }

    public StoredSubscription(NotificationCallback notificationCallback, String id) {
        this.notificationCallback = (NotificationCallback)Preconditions.checkNotNull((Object)notificationCallback);
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    public StoredSubscription(NotificationCallback notificationCallback, GenericJson subscriptionJson) {
        this(notificationCallback, (String)subscriptionJson.get((Object)"id"));
        this.setClientToken((String)subscriptionJson.get((Object)"clientToken"));
        this.setExpiration((String)subscriptionJson.get((Object)"expiration"));
        this.setTopicId((String)subscriptionJson.get((Object)"topicId"));
    }

    public synchronized NotificationCallback getNotificationCallback() {
        return this.notificationCallback;
    }

    public synchronized String getClientToken() {
        return this.clientToken;
    }

    public synchronized StoredSubscription setClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public synchronized String getExpiration() {
        return this.expiration;
    }

    public synchronized StoredSubscription setExpiration(String expiration) {
        this.expiration = expiration;
        return this;
    }

    public synchronized String getId() {
        return this.id;
    }

    public synchronized String getTopicId() {
        return this.topicId;
    }

    public synchronized StoredSubscription setTopicId(String topicId) {
        this.topicId = topicId;
        return this;
    }

    public String toString() {
        return Objects.toStringHelper(StoredSubscription.class).add("notificationCallback", (Object)this.getNotificationCallback()).add("clientToken", (Object)this.getClientToken()).add("expiration", (Object)this.getExpiration()).add("id", (Object)this.getId()).add("topicId", (Object)this.getTopicId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StoredSubscription)) {
            return false;
        }
        StoredSubscription o = (StoredSubscription)other;
        return this.getId().equals(o.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static String randomId() {
        return UUID.randomUUID().toString();
    }
}

