/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.xml.atom;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.Beta;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Types;
import com.google.api.client.xml.Xml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import com.google.api.client.xml.atom.AbstractAtomFeedParser;
import com.google.api.client.xml.atom.Atom;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class MultiKindFeedParser<T>
extends AbstractAtomFeedParser<T> {
    private final HashMap<String, Class<?>> kindToEntryClassMap = new HashMap();

    MultiKindFeedParser(XmlNamespaceDictionary namespaceDictionary, XmlPullParser parser, InputStream inputStream, Class<T> feedClass) {
        super(namespaceDictionary, parser, inputStream, feedClass);
    }

    public void setEntryClasses(Class<?> ... entryClasses) {
        int numEntries = entryClasses.length;
        HashMap<String, Class<?>> kindToEntryClassMap = this.kindToEntryClassMap;
        for (int i = 0; i < numEntries; ++i) {
            Class<?> entryClass = entryClasses[i];
            ClassInfo typeInfo = ClassInfo.of(entryClass);
            Field field = typeInfo.getField("@gd:kind");
            if (field == null) {
                throw new IllegalArgumentException("missing @gd:kind field for " + entryClass.getName());
            }
            Object entry = Types.newInstance(entryClass);
            String kind = (String)FieldInfo.getFieldValue((Field)field, (Object)entry);
            if (kind == null) {
                throw new IllegalArgumentException("missing value for @gd:kind field in " + entryClass.getName());
            }
            kindToEntryClassMap.put(kind, entryClass);
        }
    }

    protected Object parseEntryInternal() throws IOException, XmlPullParserException {
        XmlPullParser parser = this.getParser();
        String kind = parser.getAttributeValue("http://schemas.google.com/g/2005", "kind");
        Class<?> entryClass = this.kindToEntryClassMap.get(kind);
        if (entryClass == null) {
            throw new IllegalArgumentException("unrecognized kind: " + kind);
        }
        Object result = Types.newInstance(entryClass);
        Xml.parseElement((XmlPullParser)parser, (Object)result, (XmlNamespaceDictionary)this.getNamespaceDictionary(), null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E> MultiKindFeedParser<T> create(HttpResponse response, XmlNamespaceDictionary namespaceDictionary, Class<T> feedClass, Class<E> ... entryClasses) throws IOException, XmlPullParserException {
        InputStream content = response.getContent();
        try {
            Atom.checkContentType((String)response.getContentType());
            XmlPullParser parser = Xml.createParser();
            parser.setInput(content, null);
            MultiKindFeedParser<T> result = new MultiKindFeedParser<T>(namespaceDictionary, parser, content, feedClass);
            result.setEntryClasses(entryClasses);
            MultiKindFeedParser<T> multiKindFeedParser = result;
            return multiKindFeedParser;
        }
        finally {
            content.close();
        }
    }
}

