/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.datastore.v1.Value;
import com.google.protobuf.ByteString;
import java.io.Serializable;

public final class Cursor
implements Serializable {
    private static final long serialVersionUID = 4688656124180503551L;
    private final ByteString byteString;

    Cursor(ByteString byteString) {
        this.byteString = byteString;
    }

    public int hashCode() {
        return this.byteString.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Cursor && this.byteString.equals((Object)((Cursor)obj).byteString);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        StringBuilder stBuilder = new StringBuilder();
        for (int i = 0; i < this.byteString.size(); ++i) {
            stBuilder.append(String.format("%02x", this.byteString.byteAt(i)));
        }
        return toStringHelper.add("bytes", (Object)stBuilder.toString()).toString();
    }

    ByteString getByteString() {
        return this.byteString;
    }

    public String toUrlSafe() {
        return BaseEncoding.base64Url().encode(this.byteString.toByteArray());
    }

    public static Cursor fromUrlSafe(String urlSafe) {
        try {
            return Cursor.copyFrom(BaseEncoding.base64Url().decode((CharSequence)urlSafe));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unexpected decoding exception", e);
        }
    }

    public static Cursor copyFrom(byte[] bytes) {
        return new Cursor(ByteString.copyFrom((byte[])((byte[])Preconditions.checkNotNull((Object)bytes))));
    }

    Value toPb() {
        return Value.newBuilder().setBlobValue(this.byteString).build();
    }
}

