/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.PointList;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class Helper {
    public static final Charset UTF_CS = StandardCharsets.UTF_8;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final long MB = 0x100000L;
    private static final float DEGREE_FACTOR = 1.0E7f;
    private static final float ELE_FACTOR = 1000.0f;

    private Helper() {
    }

    public static Locale getLocale(String param) {
        int index;
        int pointIndex = param.indexOf(46);
        if (pointIndex > 0) {
            param = param.substring(0, pointIndex);
        }
        if ((index = (param = param.replace("-", "_")).indexOf("_")) < 0) {
            return new Locale(param);
        }
        return new Locale(param.substring(0, index), param.substring(index + 1));
    }

    public static String toLowerCase(String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    public static String toUpperCase(String string) {
        return string.toUpperCase(Locale.ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(Map<String, String> map, Writer tmpWriter) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(tmpWriter);){
            for (Map.Entry<String, String> e : map.entrySet()) {
                writer.append(e.getKey());
                writer.append('=');
                writer.append(e.getValue());
                writer.append('\n');
            }
        }
    }

    public static String readJSONFileWithoutComments(String file) throws IOException {
        return Helper.readFile(file).stream().filter(line -> !line.trim().startsWith("//")).reduce((s1, s2) -> s1 + "\n" + s2).orElse("");
    }

    public static String readJSONFileWithoutComments(InputStreamReader reader) throws IOException {
        return Helper.readFile(reader).stream().filter(line -> !line.trim().startsWith("//")).reduce((s1, s2) -> s1 + "\n" + s2).orElse("");
    }

    public static List<String> readFile(String file) throws IOException {
        return Helper.readFile(new InputStreamReader((InputStream)new FileInputStream(file), UTF_CS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(Reader simpleReader) throws IOException {
        try (BufferedReader reader = new BufferedReader(simpleReader);){
            String line;
            ArrayList<String> res = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                res.add(line);
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isToString(InputStream inputStream) throws IOException {
        int size = 8192;
        String encoding = "UTF-8";
        try (BufferedInputStream in = new BufferedInputStream(inputStream, size);){
            int numRead;
            byte[] buffer = new byte[size];
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((numRead = ((InputStream)in).read(buffer)) != -1) {
                output.write(buffer, 0, numRead);
            }
            String string = output.toString(encoding);
            return string;
        }
    }

    public static int idealIntArraySize(int need) {
        return Helper.idealByteArraySize(need * 4) / 4;
    }

    public static int idealByteArraySize(int need) {
        for (int i = 4; i < 32; ++i) {
            if (need > (1 << i) - 12) continue;
            return (1 << i) - 12;
        }
        return need;
    }

    public static boolean removeDir(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                Helper.removeDir(f);
            }
        }
        return file.delete();
    }

    public static long getTotalMB() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    public static long getUsedMB() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
    }

    public static String getMemInfo() {
        return "totalMB:" + Helper.getTotalMB() + ", usedMB:" + Helper.getUsedMB();
    }

    public static int getSizeOfObjectRef(int factor) {
        return factor * 12;
    }

    public static int getSizeOfLongArray(int length, int factor) {
        return factor * 16 + 8 * length;
    }

    public static int getSizeOfObjectArray(int length, int factor) {
        return factor * 16 + 4 * length;
    }

    public static void close(Closeable cl) {
        try {
            if (cl != null) {
                cl.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Couldn't close resource", ex);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isFileMapped(ByteBuffer bb) {
        if (bb instanceof MappedByteBuffer) {
            try {
                ((MappedByteBuffer)bb).isLoaded();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String pruneFileEnd(String file) {
        int index = file.lastIndexOf(".");
        if (index < 0) {
            return file;
        }
        return file.substring(0, index);
    }

    public static List<Double> createDoubleList(double[] values) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (double v : values) {
            list.add(v);
        }
        return list;
    }

    public static PointList createPointList(double ... list) {
        if (list.length % 2 != 0) {
            throw new IllegalArgumentException("list should consist of lat,lon pairs!");
        }
        int max = list.length / 2;
        PointList res = new PointList(max, false);
        for (int i = 0; i < max; ++i) {
            res.add(list[2 * i], list[2 * i + 1], Double.NaN);
        }
        return res;
    }

    public static PointList createPointList3D(double ... list) {
        if (list.length % 3 != 0) {
            throw new IllegalArgumentException("list should consist of lat,lon,ele tuples!");
        }
        int max = list.length / 3;
        PointList res = new PointList(max, true);
        for (int i = 0; i < max; ++i) {
            res.add(list[3 * i], list[3 * i + 1], list[3 * i + 2]);
        }
        return res;
    }

    public static int degreeToInt(double deg) {
        if (deg >= Double.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (deg <= -1.7976931348623157E308) {
            return -2147483647;
        }
        return (int)(deg * 1.0E7);
    }

    public static double intToDegree(int storedInt) {
        if (storedInt == Integer.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        if (storedInt == -2147483647) {
            return -1.7976931348623157E308;
        }
        return (double)storedInt / 1.0E7;
    }

    public static int eleToInt(double ele) {
        if (ele >= 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)(ele * 1000.0);
    }

    public static double intToEle(int integEle) {
        if (integEle == Integer.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        return (float)integEle / 1000.0f;
    }

    public static String nf(long no) {
        return NumberFormat.getInstance(Locale.ENGLISH).format(no);
    }

    public static String firstBig(String sayText) {
        if (sayText == null || sayText.length() <= 0) {
            return sayText;
        }
        return Character.toUpperCase(sayText.charAt(0)) + sayText.substring(1);
    }

    public static double keepIn(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double round(double value, int decimalPlaces) {
        double factor = Math.pow(10.0, decimalPlaces);
        return (double)Math.round(value * factor) / factor;
    }

    public static double round6(double value) {
        return Helper.round(value, 6);
    }

    public static double round4(double value) {
        return Helper.round(value, 4);
    }

    public static double round2(double value) {
        return Helper.round(value, 2);
    }

    public static DateFormat createFormatter() {
        return Helper.createFormatter("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public static DateFormat createFormatter(String str) {
        SimpleDateFormat df = new SimpleDateFormat(str, Locale.ENGLISH);
        df.setTimeZone(UTC);
        return df;
    }

    public static Object toObject(String string) {
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return Boolean.parseBoolean(string);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ex) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException ex2) {
                try {
                    return Float.valueOf(Float.parseFloat(string));
                }
                catch (NumberFormatException ex3) {
                    try {
                        return Double.parseDouble(string);
                    }
                    catch (NumberFormatException ex4) {
                        return string;
                    }
                }
            }
        }
    }

    public static String camelCaseToUnderScore(String key) {
        if (key.isEmpty()) {
            return key;
        }
        StringBuilder sb = new StringBuilder(key.length());
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_").append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underScoreToCamelCase(String key) {
        if (key.isEmpty()) {
            return key;
        }
        StringBuilder sb = new StringBuilder(key.length());
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '_') {
                if (++i < key.length()) {
                    sb.append(Character.toUpperCase(key.charAt(i)));
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String join(String delimiter, List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.size(); ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(strings.get(i));
        }
        return sb.toString();
    }

    public static List<String> parseList(String listStr) {
        String trimmed = listStr.trim();
        if (trimmed.length() < 2) {
            return Collections.emptyList();
        }
        String[] items = trimmed.substring(1, trimmed.length() - 1).split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String item : items) {
            String s = item.trim();
            if (s.isEmpty()) continue;
            result.add(s);
        }
        return result;
    }

    public static int staticHashCode(String str) {
        int len = str.length();
        int val = 0;
        for (int idx = 0; idx < len; ++idx) {
            val = 31 * val + str.charAt(idx);
        }
        return val;
    }
}

