/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;

@Path(value="nearest")
@Produces(value={"application/json"})
public class NearestResource {
    private final DistanceCalc calc = DistanceCalcEarth.DIST_EARTH;
    private final LocationIndex index;
    private final boolean hasElevation;

    @Inject
    NearestResource(LocationIndex index, @Named(value="hasElevation") Boolean hasElevation) {
        this.index = index;
        this.hasElevation = hasElevation;
    }

    @GET
    public Response doGet(@QueryParam(value="point") GHPoint point, @QueryParam(value="elevation") @DefaultValue(value="false") boolean elevation) {
        Snap snap = this.index.findClosest(point.lat, point.lon, EdgeFilter.ALL_EDGES);
        if (snap.isValid()) {
            double[] dArray;
            GHPoint3D snappedPoint = snap.getSnappedPoint();
            if (this.hasElevation && elevation) {
                double[] dArray2 = new double[3];
                dArray2[0] = snappedPoint.lon;
                dArray2[1] = snappedPoint.lat;
                dArray = dArray2;
                dArray2[2] = snappedPoint.ele;
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = snappedPoint.lon;
                dArray = dArray3;
                dArray3[1] = snappedPoint.lat;
            }
            double[] coordinates = dArray;
            return new Response(coordinates, this.calc.calcDist(point.lat, point.lon, snappedPoint.lat, snappedPoint.lon));
        }
        throw new WebApplicationException("Nearest point cannot be found!");
    }

    public static class Response {
        public final String type = "Point";
        public final double[] coordinates;
        public final double distance;

        @JsonCreator
        Response(@JsonProperty(value="coordinates") double[] coordinates, @JsonProperty(value="distance") double distance) {
            this.coordinates = coordinates;
            this.distance = distance;
        }
    }
}

