/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.gtfs.GraphHopperGtfs;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.PtRouterFreeWalkImpl;
import com.graphhopper.gtfs.PtRouterImpl;
import com.graphhopper.http.GHJerseyViolationExceptionMapper;
import com.graphhopper.http.GraphHopperBundleConfiguration;
import com.graphhopper.http.GraphHopperManaged;
import com.graphhopper.http.IllegalArgumentExceptionMapper;
import com.graphhopper.http.LegacyProfileResolver;
import com.graphhopper.http.MultiExceptionGPXMessageBodyWriter;
import com.graphhopper.http.MultiExceptionMapper;
import com.graphhopper.http.ProfileResolver;
import com.graphhopper.http.PtRedirectFilter;
import com.graphhopper.http.TypeGPXFilter;
import com.graphhopper.http.health.GraphHopperHealthCheck;
import com.graphhopper.isochrone.algorithm.JTSTriangulator;
import com.graphhopper.isochrone.algorithm.Triangulator;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.resources.HealthCheckResource;
import com.graphhopper.resources.I18NResource;
import com.graphhopper.resources.InfoResource;
import com.graphhopper.resources.IsochroneResource;
import com.graphhopper.resources.MVTResource;
import com.graphhopper.resources.MapMatchingResource;
import com.graphhopper.resources.NearestResource;
import com.graphhopper.resources.PtIsochroneResource;
import com.graphhopper.resources.PtMVTResource;
import com.graphhopper.resources.PtRouteResource;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.resources.SPTResource;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.text.DateFormat;
import javax.inject.Inject;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class GraphHopperBundle
implements ConfiguredBundle<GraphHopperBundleConfiguration> {
    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.setObjectMapper(io.dropwizard.jackson.Jackson.newMinimalObjectMapper());
        bootstrap.getObjectMapper().registerModule((Module)new Jdk8Module());
        Jackson.initObjectMapper((ObjectMapper)bootstrap.getObjectMapper());
        bootstrap.getObjectMapper().setDateFormat((DateFormat)new StdDateFormat());
        bootstrap.getObjectMapper().enable(new MapperFeature[]{MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING});
    }

    public void run(final GraphHopperBundleConfiguration configuration, Environment environment) {
        for (Object k : System.getProperties().keySet()) {
            if (!(k instanceof String) || !((String)k).startsWith("graphhopper.")) continue;
            throw new IllegalArgumentException("You need to prefix system parameters with '-Ddw.graphhopper.' instead of '-Dgraphhopper.' see #1879 and #1897");
        }
        environment.jersey().register((Object)new GHJerseyViolationExceptionMapper());
        environment.jersey().register((Object)new TypeGPXFilter());
        environment.jersey().register((Object)new MultiExceptionMapper());
        environment.jersey().register((Object)new MultiExceptionGPXMessageBodyWriter());
        environment.jersey().register((Object)new IllegalArgumentExceptionMapper());
        GraphHopperManaged graphHopperManaged = new GraphHopperManaged(configuration.getGraphHopperConfiguration());
        environment.lifecycle().manage((Managed)graphHopperManaged);
        final GraphHopper graphHopper = graphHopperManaged.getGraphHopper();
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(configuration.getGraphHopperConfiguration()).to(GraphHopperConfig.class);
                this.bind(graphHopper).to(GraphHopper.class);
                this.bind(new JTSTriangulator(graphHopper.getRouterConfig())).to(Triangulator.class);
                this.bindFactory(PathDetailsBuilderFactoryFactory.class).to(PathDetailsBuilderFactory.class);
                this.bindFactory(LegacyProfileResolverFactory.class).to(LegacyProfileResolver.class);
                this.bindFactory(ProfileResolverFactory.class).to(ProfileResolver.class);
                this.bindFactory(HasElevation.class).to(Boolean.class).named("hasElevation");
                this.bindFactory(LocationIndexFactory.class).to(LocationIndex.class);
                this.bindFactory(TranslationMapFactory.class).to(TranslationMap.class);
                this.bindFactory(EncodingManagerFactory.class).to(EncodingManager.class);
                this.bindFactory(BaseGraphFactory.class).to(BaseGraph.class);
                this.bindFactory(GtfsStorageFactory.class).to(GtfsStorage.class);
            }
        });
        environment.jersey().register(MVTResource.class);
        environment.jersey().register(NearestResource.class);
        environment.jersey().register(RouteResource.class);
        environment.jersey().register(IsochroneResource.class);
        environment.jersey().register(MapMatchingResource.class);
        if (configuration.getGraphHopperConfiguration().has("gtfs.file")) {
            environment.jersey().register((Object)new AbstractBinder(){

                protected void configure() {
                    if (configuration.getGraphHopperConfiguration().getBool("gtfs.free_walk", false)) {
                        this.bind(PtRouterFreeWalkImpl.class).to(PtRouter.class);
                    } else {
                        this.bind(PtRouterImpl.class).to(PtRouter.class);
                    }
                }
            });
            environment.jersey().register(PtRouteResource.class);
            environment.jersey().register(PtIsochroneResource.class);
            environment.jersey().register(PtMVTResource.class);
            environment.jersey().register(PtRedirectFilter.class);
        }
        environment.jersey().register(SPTResource.class);
        environment.jersey().register(I18NResource.class);
        environment.jersey().register(InfoResource.class);
        environment.healthChecks().register("graphhopper", (HealthCheck)new GraphHopperHealthCheck(graphHopper));
        environment.jersey().register((Object)environment.healthChecks());
        environment.jersey().register(HealthCheckResource.class);
    }

    static class HasElevation
    implements Factory<Boolean> {
        @Inject
        GraphHopper graphHopper;

        HasElevation() {
        }

        public Boolean provide() {
            return this.graphHopper.hasElevation();
        }

        public void dispose(Boolean instance) {
        }
    }

    static class PathDetailsBuilderFactoryFactory
    implements Factory<PathDetailsBuilderFactory> {
        @Inject
        GraphHopper graphHopper;

        PathDetailsBuilderFactoryFactory() {
        }

        public PathDetailsBuilderFactory provide() {
            return this.graphHopper.getPathDetailsBuilderFactory();
        }

        public void dispose(PathDetailsBuilderFactory profileResolver) {
        }
    }

    static class ProfileResolverFactory
    implements Factory<ProfileResolver> {
        @Inject
        GraphHopper graphHopper;
        @Inject
        LegacyProfileResolver legacyProfileResolver;

        ProfileResolverFactory() {
        }

        public ProfileResolver provide() {
            return new ProfileResolver(this.graphHopper.getProfiles(), this.legacyProfileResolver);
        }

        public void dispose(ProfileResolver instance) {
        }
    }

    static class LegacyProfileResolverFactory
    implements Factory<LegacyProfileResolver> {
        @Inject
        GraphHopper graphHopper;

        LegacyProfileResolverFactory() {
        }

        public LegacyProfileResolver provide() {
            return new LegacyProfileResolver(this.graphHopper.getEncodingManager(), this.graphHopper.getProfiles(), this.graphHopper.getCHPreparationHandler().getCHProfiles(), this.graphHopper.getLMPreparationHandler().getLMProfiles());
        }

        public void dispose(LegacyProfileResolver profileResolver) {
        }
    }

    static class LocationIndexFactory
    implements Factory<LocationIndex> {
        @Inject
        GraphHopper graphHopper;

        LocationIndexFactory() {
        }

        public LocationIndex provide() {
            return this.graphHopper.getLocationIndex();
        }

        public void dispose(LocationIndex instance) {
        }
    }

    static class EncodingManagerFactory
    implements Factory<EncodingManager> {
        @Inject
        GraphHopper graphHopper;

        EncodingManagerFactory() {
        }

        public EncodingManager provide() {
            return this.graphHopper.getEncodingManager();
        }

        public void dispose(EncodingManager instance) {
        }
    }

    static class GtfsStorageFactory
    implements Factory<GtfsStorage> {
        @Inject
        GraphHopperGtfs graphHopper;

        GtfsStorageFactory() {
        }

        public GtfsStorage provide() {
            return this.graphHopper.getGtfsStorage();
        }

        public void dispose(GtfsStorage instance) {
        }
    }

    static class BaseGraphFactory
    implements Factory<BaseGraph> {
        @Inject
        GraphHopper graphHopper;

        BaseGraphFactory() {
        }

        public BaseGraph provide() {
            return this.graphHopper.getBaseGraph();
        }

        public void dispose(BaseGraph instance) {
        }
    }

    static class TranslationMapFactory
    implements Factory<TranslationMap> {
        @Inject
        GraphHopper graphHopper;

        TranslationMapFactory() {
        }

        public TranslationMap provide() {
            return this.graphHopper.getTranslationMap();
        }

        public void dispose(TranslationMap instance) {
        }
    }
}

