/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.graphhopper.config.Profile;
import com.graphhopper.http.LegacyProfileResolver;
import com.graphhopper.util.PMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProfileResolver {
    protected final Map<String, Profile> profilesByName;
    private final LegacyProfileResolver legacyProfileResolver;

    public ProfileResolver(List<Profile> profiles, LegacyProfileResolver legacyProfileResolver) {
        this.profilesByName = new LinkedHashMap<String, Profile>(profiles.size());
        profiles.forEach(p -> {
            if (this.profilesByName.put(p.getName(), (Profile)p) != null) {
                throw new IllegalArgumentException("Profiles must have distinct names");
            }
        });
        this.legacyProfileResolver = legacyProfileResolver;
    }

    public String resolveProfile(PMap hints) {
        String profileName = hints.getString("profile", "");
        if (profileName.isEmpty()) {
            boolean hasCurbsides = hints.getBool("has_curbsides", false);
            ProfileResolver.enableEdgeBasedIfThereAreCurbsides(hasCurbsides, hints);
            return this.legacyProfileResolver.resolveProfile(hints).getName();
        }
        ProfileResolver.errorIfLegacyParameters(hints);
        String profile = this.doResolveProfile(profileName, hints);
        if (profile == null) {
            throw new IllegalArgumentException("The requested profile '" + profileName + "' does not exist.\nAvailable profiles: " + this.profilesByName.keySet());
        }
        return profile;
    }

    protected String doResolveProfile(String profileName, PMap hints) {
        Profile profile = this.profilesByName.get(profileName);
        return profile == null ? null : profile.getName();
    }

    public static void enableEdgeBasedIfThereAreCurbsides(boolean hasCurbsides, PMap hints) {
        if (hasCurbsides) {
            if (!hints.getBool("turn_costs", true)) {
                throw new IllegalArgumentException("Disabling 'turn_costs' when using 'curbside' is not allowed");
            }
            if (!hints.getBool("edge_based", true)) {
                throw new IllegalArgumentException("Disabling 'edge_based' when using 'curbside' is not allowed");
            }
            hints.putObject("edge_based", (Object)true);
        }
    }

    public static void errorIfLegacyParameters(PMap hints) {
        if (hints.has("weighting")) {
            throw new IllegalArgumentException("Since you are using the 'profile' parameter, do not use the 'weighting' parameter. You used 'weighting=" + hints.getString("weighting", "") + "'");
        }
        if (hints.has("vehicle")) {
            throw new IllegalArgumentException("Since you are using the 'profile' parameter, do not use the 'vehicle' parameter. You used 'vehicle=" + hints.getString("vehicle", "") + "'");
        }
        if (hints.has("edge_based")) {
            throw new IllegalArgumentException("Since you are using the 'profile' parameter, do not use the 'edge_based' parameter. You used 'edge_based=" + hints.getBool("edge_based", false) + "'");
        }
        if (hints.has("turn_costs")) {
            throw new IllegalArgumentException("Since you are using the 'profile' parameter, do not use the 'turn_costs' parameter. You used 'turn_costs=" + hints.getBool("turn_costs", false) + "'");
        }
    }
}

