/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.Request;
import com.graphhopper.http.DurationParam;
import com.graphhopper.http.GHLocationParam;
import com.graphhopper.http.OffsetDateTimeParam;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import io.dropwizard.jersey.params.AbstractParam;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="route-pt")
public class PtRouteResource {
    private final GraphHopperConfig config;
    private final PtRouter ptRouter;

    @Inject
    public PtRouteResource(GraphHopperConfig config, PtRouter ptRouter) {
        this.config = config;
        this.ptRouter = ptRouter;
    }

    @GET
    @Produces(value={"application/json"})
    public ObjectNode route(@QueryParam(value="point") @Size(min=2, max=2) @Size(min=2, max=2) List<GHLocationParam> requestPoints, @QueryParam(value="pt.earliest_departure_time") @NotNull OffsetDateTimeParam departureTimeParam, @QueryParam(value="pt.profile_duration") DurationParam profileDuration, @QueryParam(value="pt.arrive_by") @DefaultValue(value="false") boolean arriveBy, @QueryParam(value="locale") String localeStr, @QueryParam(value="pt.ignore_transfers") Boolean ignoreTransfers, @QueryParam(value="pt.profile") Boolean profileQuery, @QueryParam(value="pt.limit_solutions") Integer limitSolutions, @QueryParam(value="pt.limit_trip_time") DurationParam limitTripTime, @QueryParam(value="pt.limit_street_time") DurationParam limitStreetTime, @QueryParam(value="pt.access_profile") String accessProfile, @QueryParam(value="pt.beta_access_time") Double betaAccessTime, @QueryParam(value="pt.egress_profile") String egressProfile, @QueryParam(value="pt.beta_egress_time") Double betaEgressTime) {
        StopWatch stopWatch = new StopWatch().start();
        List points = requestPoints.stream().map(AbstractParam::get).collect(Collectors.toList());
        Instant departureTime = ((OffsetDateTime)departureTimeParam.get()).toInstant();
        Request request = new Request(points, departureTime);
        request.setArriveBy(arriveBy);
        Optional.ofNullable(profileQuery).ifPresent(arg_0 -> ((Request)request).setProfileQuery(arg_0));
        Optional.ofNullable((Duration)profileDuration.get()).ifPresent(arg_0 -> ((Request)request).setMaxProfileDuration(arg_0));
        Optional.ofNullable(ignoreTransfers).ifPresent(arg_0 -> ((Request)request).setIgnoreTransfers(arg_0));
        Optional.ofNullable(localeStr).ifPresent(s -> request.setLocale(Helper.getLocale((String)s)));
        Optional.ofNullable(limitSolutions).ifPresent(arg_0 -> ((Request)request).setLimitSolutions(arg_0));
        Optional.ofNullable((Duration)limitTripTime.get()).ifPresent(arg_0 -> ((Request)request).setLimitTripTime(arg_0));
        Optional.ofNullable((Duration)limitStreetTime.get()).ifPresent(arg_0 -> ((Request)request).setLimitStreetTime(arg_0));
        Optional.ofNullable(accessProfile).ifPresent(arg_0 -> ((Request)request).setAccessProfile(arg_0));
        Optional.ofNullable(betaAccessTime).ifPresent(arg_0 -> ((Request)request).setBetaAccessTime(arg_0));
        Optional.ofNullable(egressProfile).ifPresent(arg_0 -> ((Request)request).setEgressProfile(arg_0));
        Optional.ofNullable(betaEgressTime).ifPresent(arg_0 -> ((Request)request).setBetaEgressTime(arg_0));
        GHResponse route = this.ptRouter.route(request);
        return ResponsePathSerializer.jsonObject((GHResponse)route, (ResponsePathSerializer.Info)new ResponsePathSerializer.Info(this.config.getCopyrights(), (long)Math.round(stopWatch.stop().getMillis()), null), (boolean)true, (boolean)true, (boolean)false, (boolean)false, (double)-1.0);
    }
}

