/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.util.StringUtils;

public class TraceObject {
    public static final int CALLABLE_STATEMENT = 0;
    public static final int CONNECTION = 1;
    public static final int DATABASE_META_DATA = 2;
    public static final int PREPARED_STATEMENT = 3;
    public static final int RESULT_SET = 4;
    public static final int RESULT_SET_META_DATA = 5;
    public static final int SAVEPOINT = 6;
    public static final int SQL_EXCEPTION = 7;
    public static final int STATEMENT = 8;
    public static final int BLOB = 9;
    public static final int CLOB = 10;
    public static final int PARAMETER_META_DATA = 11;
    public static final int DATASOURCE = 12;
    public static final int XA_DATASOURCE = 13;
    public static final int XID = 14;
    private static int LAST = 15;
    private Trace trace;
    private static final int[] ID = new int[LAST];
    private static final String[] PREFIX = new String[]{"call", "conn", "dbMeta", "prep", "rs", "rsMeta", "sp", "ex", "stat", "blob", "clob", "pMeta", "ds", "xads", "xid"};
    private int type;
    private int id;

    protected void setTrace(Trace trace, int type, int id) {
        this.trace = trace;
        this.type = type;
        this.id = id;
    }

    protected int getTraceId() {
        return this.id;
    }

    public String toString() {
        return PREFIX[this.type] + this.id;
    }

    protected int getNextId(int type) {
        int n = type;
        int n2 = ID[n];
        ID[n] = n2 + 1;
        return n2;
    }

    protected boolean debug() {
        return this.trace.debug();
    }

    protected boolean info() {
        return this.trace.info();
    }

    protected Trace getTrace() {
        return this.trace;
    }

    protected void debugCodeAssign(String className, int type, int id) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(className + " " + this.toString() + " = ");
    }

    protected void infoCodeAssign(String className, int type, int id) {
        if (!this.trace.info()) {
            return;
        }
        this.trace.infoCode(className + " " + this.toString() + " = ");
    }

    protected void debugCodeCall(String text) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(this.toString() + "." + text + "();");
    }

    protected void debugCodeCall(String text, long param) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(this.toString() + "." + text + "(" + param + ");");
    }

    protected void debugCodeCall(String text, String param) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(this.toString() + "." + text + "(" + this.quote(param) + ");");
    }

    protected void debugCode(String text) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(this.toString() + "." + text);
    }

    protected String quote(String s) {
        return StringUtils.quoteJavaString(s);
    }

    protected String quoteTime(Time x) {
        if (x == null) {
            return "null";
        }
        return "Time.valueOf(\"" + x.toString() + "\")";
    }

    protected String quoteTimestamp(Timestamp x) {
        if (x == null) {
            return "null";
        }
        return "Timestamp.valueOf(\"" + x.toString() + "\")";
    }

    protected String quoteDate(Date x) {
        if (x == null) {
            return "null";
        }
        return "Date.valueOf(\"" + x.toString() + "\")";
    }

    protected String quoteBigDecimal(BigDecimal x) {
        if (x == null) {
            return "null";
        }
        return "new BigDecimal(\"" + x.toString() + "\")";
    }

    protected String quoteBytes(byte[] x) {
        if (x == null) {
            return "null";
        }
        return "new byte[" + x.length + "]";
    }

    protected String quoteArray(String[] s) {
        return StringUtils.quoteJavaStringArray(s);
    }

    protected String quoteIntArray(int[] s) {
        return StringUtils.quoteJavaIntArray(s);
    }

    protected SQLException logAndConvert(Throwable e) {
        if (this.trace == null) {
            TraceSystem.traceThrowable(e);
        } else {
            if (e instanceof SQLException) {
                this.trace.error("SQLException", e);
                return (SQLException)e;
            }
            this.trace.error("Uncaught Exception", e);
        }
        return Message.convert(e);
    }
}

