/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.server.OdbcServer;
import org.h2.server.Service;
import org.h2.server.TcpServer;
import org.h2.server.ftp.FtpServer;
import org.h2.server.web.WebServer;
import org.h2.util.MathUtils;
import org.h2.util.StartBrowser;

public class Server
implements Runnable {
    private String name;
    private Service service;

    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [options]");
        System.out.println("By default, -tcp, -web, -browser and -odbc are started");
        System.out.println("-tcp (start the TCP Server)");
        System.out.println("-tcpPort <port> (default: 9092)");
        System.out.println("-tcpSSL [true|false]");
        System.out.println("-tcpAllowOthers [true|false]");
        System.out.println("-tcpPassword {password} (the password for shutting down a TCP Server)");
        System.out.println("-tcpShutdown {url} (shutdown the TCP Server, URL example: tcp://localhost:9094)");
        System.out.println("-tcpShutdownForce [true|false] (don't wait for other connections to close)");
        System.out.println("-web (start the Web Server)");
        System.out.println("-webPort <port> (default: 8082)");
        System.out.println("-webSSL [true|false}");
        System.out.println("-webAllowOthers [true|false}");
        System.out.println("-browser (start a browser)");
        System.out.println("-odbc (start the ODBC Server)");
        System.out.println("-odbcPort <port> (default: 9083)");
        System.out.println("-odbcAllowOthers [true|false]");
        System.out.println("-ftp (start the FTP Server)");
        System.out.println("-ftpPort <port> (default: 8021)");
        System.out.println("-ftpDir <directory> (default: ftp, use jdbc:... to access a database)");
        System.out.println("-ftpRead <readUserName> (default: guest)");
        System.out.println("-ftpWrite <writeUserName> (default: sa)");
        System.out.println("-ftpWritePassword <password> (default: sa)");
        System.out.println("-log [true|false]");
        System.out.println("-baseDir <directory>");
        System.out.println("-ifExists [true|false] (only existing databases may be opened)");
    }

    private Server() {
    }

    public static void main(String[] args) throws SQLException {
        new Server().run(args);
    }

    private void run(String[] args) throws SQLException {
        boolean tcpStart = false;
        boolean odbcStart = false;
        boolean webStart = false;
        boolean ftpStart = false;
        boolean browserStart = false;
        boolean tcpShutdown = false;
        boolean tcpShutdownForce = false;
        String tcpPassword = "";
        String tcpShutdownServer = "";
        boolean startDefaultServers = true;
        for (int i = 0; args != null && i < args.length; ++i) {
            String a = args[i];
            if (a.equals("-?") || a.equals("-help")) {
                this.showUsage();
                return;
            }
            if (a.equals("-web")) {
                startDefaultServers = false;
                webStart = true;
                continue;
            }
            if (a.equals("-odbc")) {
                startDefaultServers = false;
                odbcStart = true;
                continue;
            }
            if (a.equals("-tcp")) {
                startDefaultServers = false;
                tcpStart = true;
                continue;
            }
            if (a.equals("-ftp")) {
                startDefaultServers = false;
                ftpStart = true;
                continue;
            }
            if (a.equals("-tcpShutdown")) {
                startDefaultServers = false;
                tcpShutdown = true;
                tcpShutdownServer = args[++i];
                continue;
            }
            if (a.equals("-tcpPassword")) {
                tcpPassword = args[++i];
                continue;
            }
            if (a.equals("-tcpShutdownForce")) {
                tcpShutdownForce = true;
                continue;
            }
            if (!a.equals("-browser")) continue;
            startDefaultServers = false;
            browserStart = true;
        }
        if (startDefaultServers) {
            tcpStart = true;
            odbcStart = true;
            webStart = true;
            browserStart = true;
        }
        if (tcpShutdown) {
            System.out.println("Shutting down TCP Server at " + tcpShutdownServer);
            Server.shutdownTcpServer(tcpShutdownServer, tcpPassword, tcpShutdownForce);
        }
        if (tcpStart) {
            Server tcp = Server.createTcpServer(args);
            try {
                tcp.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            System.out.println(tcp.getStatus());
        }
        if (odbcStart) {
            Server odbc = Server.createOdbcServer(args);
            try {
                odbc.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            System.out.println(odbc.getStatus());
        }
        if (webStart) {
            Server web = Server.createWebServer(args);
            try {
                web.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            System.out.println(web.getStatus());
            if (browserStart) {
                StartBrowser.openURL(web.getURL());
            }
        }
        if (ftpStart) {
            Server ftp = Server.createFtpServer(args);
            try {
                ftp.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            System.out.println(ftp.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownTcpServer(String url, String password, boolean force) throws SQLException {
        int port = 9092;
        int idx = url.indexOf(58, "jdbc:h2:".length());
        if (idx >= 0) {
            String p = url.substring(idx + 1);
            if ((idx = p.indexOf(47)) >= 0) {
                p = p.substring(0, idx);
            }
            port = MathUtils.decodeInt(p);
        }
        String db = TcpServer.getManagementDbName(port);
        try {
            Driver.load();
        }
        catch (Throwable e) {
            throw Message.convert(e);
        }
        for (int i = 0; i < 2; ++i) {
            try {
                Connection conn = DriverManager.getConnection("jdbc:h2:" + url + "/" + db, "sa", password);
                PreparedStatement prep = conn.prepareStatement("CALL STOP_SERVER(?, ?, ?)");
                prep.setInt(1, port);
                prep.setString(2, password);
                prep.setInt(3, force ? 1 : 0);
                try {
                    prep.execute();
                    break;
                }
                catch (SQLException e) {
                    if (force) {
                        break;
                    }
                    throw e;
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {}
                }
            }
            catch (SQLException e) {
                if (i != 1) continue;
                throw e;
            }
        }
    }

    private String getStatus() {
        StringBuffer buff = new StringBuffer();
        if (this.isRunning()) {
            buff.append(this.service.getType());
            buff.append(" server running on ");
            buff.append(this.service.getURL());
            buff.append(" (");
            if (this.service.getAllowOthers()) {
                buff.append("others can connect");
            } else {
                buff.append("only local connections");
            }
            buff.append(")");
        } else {
            buff.append("Port is in use, maybe another " + this.service.getType() + " server already running on ");
            buff.append(this.service.getURL());
        }
        return buff.toString();
    }

    public static Server createWebServer(String[] args) throws SQLException {
        return new Server("H2 Console Server", new WebServer(), args);
    }

    public static Server createFtpServer(String[] args) throws SQLException {
        return new Server("H2 FTP Server", new FtpServer(), args);
    }

    public static Server createTcpServer(String[] args) throws SQLException {
        return new Server("H2 TCP Server", new TcpServer(), args);
    }

    public static Server createOdbcServer(String[] args) throws SQLException {
        return new Server("H2 ODBC Server", new OdbcServer(), args);
    }

    public Server start() throws SQLException {
        this.service.start();
        Thread t = new Thread(this);
        t.setName(this.name);
        t.start();
        for (int i = 1; i < 64; i += i) {
            Server.wait(i);
            if (!this.isRunning()) continue;
            return this;
        }
        throw Message.getSQLException(90067);
    }

    private static void wait(int i) {
        try {
            Thread.sleep(i * i);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isRunning() {
        return this.service.isRunning();
    }

    public void stop() {
        this.service.stop();
    }

    public String getURL() {
        return this.service.getURL();
    }

    private Server(String name, Service service, String[] args) throws SQLException {
        this.name = name;
        this.service = service;
        try {
            service.init(args);
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    public void run() {
        try {
            this.service.listen();
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
        }
    }
}

