/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.security.SecureSocketFactory;

public class NetUtils {
    public static Socket createLoopbackSocket(int port, boolean ssl) throws IOException, SQLException {
        InetAddress address = InetAddress.getByName("127.0.0.1");
        return NetUtils.createSocket(address, port, ssl);
    }

    public static Socket createSocket(InetAddress address, int port, boolean ssl) throws IOException, SQLException {
        if (ssl) {
            SecureSocketFactory f = SecureSocketFactory.getInstance();
            return f.createSocket(address, port);
        }
        return new Socket(address, port);
    }

    public static ServerSocket createServerSocket(int port, boolean ssl) throws SQLException {
        try {
            return NetUtils.createServerSocketTry(port, ssl);
        }
        catch (SQLException e) {
            return NetUtils.createServerSocketTry(port, ssl);
        }
    }

    private static ServerSocket createServerSocketTry(int port, boolean ssl) throws SQLException {
        try {
            if (ssl) {
                SecureSocketFactory f = SecureSocketFactory.getInstance();
                return f.createServerSocket(port);
            }
            return new ServerSocket(port);
        }
        catch (BindException be) {
            throw Message.getSQLException(90061, new String[]{"" + port}, be);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }
}

