/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Enumeration;
import org.h2.message.Message;

public class Permutations
implements Enumeration {
    private Object[] inArray;
    private int n;
    private int m;
    private int[] index;
    private boolean hasMore = true;

    public Permutations(Object[] inArray) {
        this(inArray, inArray.length);
    }

    public Permutations(Object[] inArray, int m) {
        this.inArray = inArray;
        this.n = inArray.length;
        this.m = m;
        if (this.n < m || m < 0) {
            throw Message.getInternalError("n < m or m < 0");
        }
        this.index = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.index[i] = i;
        }
        this.reverseAfter(m - 1);
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    private void moveIndex() {
        int i = this.rightmostDip();
        if (i < 0) {
            this.hasMore = false;
            return;
        }
        int leastToRightIndex = i + 1;
        for (int j = i + 2; j < this.n; ++j) {
            if (this.index[j] >= this.index[leastToRightIndex] || this.index[j] <= this.index[i]) continue;
            leastToRightIndex = j;
        }
        int t = this.index[i];
        this.index[i] = this.index[leastToRightIndex];
        this.index[leastToRightIndex] = t;
        if (this.m - 1 > i) {
            this.reverseAfter(i);
            this.reverseAfter(this.m - 1);
        }
    }

    public Object nextElement() {
        if (!this.hasMore) {
            return null;
        }
        Object[] out = new Object[this.m];
        for (int i = 0; i < this.m; ++i) {
            out[i] = this.inArray[this.index[i]];
        }
        this.moveIndex();
        return out;
    }

    private void reverseAfter(int i) {
        int start = i + 1;
        for (int end = this.n - 1; start < end; ++start, --end) {
            int t = this.index[start];
            this.index[start] = this.index[end];
            this.index[end] = t;
        }
    }

    private int rightmostDip() {
        for (int i = this.n - 2; i >= 0; --i) {
            if (this.index[i] >= this.index[i + 1]) continue;
            return i;
        }
        return -1;
    }
}

