/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.LinearHashEntry;
import org.h2.index.LinearHashIndex;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class LinearHashBucket
extends Record {
    private LinearHashIndex index;
    private int nextBucket;
    private ObjectArray records;
    private boolean writePos;

    public LinearHashBucket(LinearHashIndex index, DataPage s) throws SQLException {
        this.index = index;
        this.writePos = s.readByte() == 80;
        this.nextBucket = s.readInt();
        int len = s.readInt();
        this.records = new ObjectArray();
        for (int i = 0; i < len; ++i) {
            LinearHashEntry entry = new LinearHashEntry();
            if (!this.writePos) {
                Value key;
                entry.key = key = s.readValue();
            }
            entry.hash = s.readInt();
            entry.value = s.readInt();
            entry.home = index.getPos(entry.hash);
            this.records.add(entry);
        }
    }

    public LinearHashBucket(LinearHashIndex index) {
        this.index = index;
        this.records = new ObjectArray();
        this.nextBucket = -1;
    }

    private void update(Session session) throws SQLException {
        this.index.updateBucket(session, this);
    }

    void setNext(Session session, int nextBucket) throws SQLException {
        this.nextBucket = nextBucket;
        this.update(session);
    }

    int getNextBucket() {
        return this.nextBucket;
    }

    LinearHashEntry getRecord(int i) {
        return (LinearHashEntry)this.records.get(i);
    }

    void addRecord(Session session, LinearHashEntry r) throws SQLException {
        this.records.add(r);
        this.update(session);
    }

    void removeRecord(Session session, int i) throws SQLException {
        this.records.remove(i);
        this.update(session);
    }

    int getRecordSize() {
        return this.records.size();
    }

    public void write(DataPage buff) throws SQLException {
        this.getRealByteCount(buff);
        buff.writeByte((byte)66);
        if (this.writePos) {
            buff.writeByte((byte)80);
        } else {
            buff.writeByte((byte)68);
        }
        buff.writeInt(this.nextBucket);
        buff.writeInt(this.records.size());
        for (int i = 0; i < this.records.size(); ++i) {
            LinearHashEntry record = (LinearHashEntry)this.records.get(i);
            if (!this.writePos) {
                buff.writeValue(record.key);
            }
            buff.writeInt(record.hash);
            buff.writeInt(record.value);
        }
    }

    public int getByteCount(DataPage dummy) throws SQLException {
        return this.index.getBucketSize();
    }

    public int getRealByteCount(DataPage dummy) throws SQLException {
        int size = 2 + dummy.getIntLen() + dummy.getIntLen();
        int dataSize = 0;
        for (int i = 0; i < this.records.size(); ++i) {
            LinearHashEntry record = (LinearHashEntry)this.records.get(i);
            dataSize += dummy.getValueLen(record.key);
            size += 2 * dummy.getIntLen();
        }
        if (size + dataSize >= this.index.getBucketSize()) {
            this.writePos = true;
            return size;
        }
        this.writePos = false;
        return size + dataSize;
    }

    public boolean isEmpty() {
        return false;
    }
}

