/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.tools.Backup;
import org.h2.tools.RunScript;
import org.h2.util.JdbcUtils;

public class CreateCluster {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " -urlSource <url> -urlTarget <url> -user <user> [-password <pwd>] -serverlist <serverlist>");
    }

    public static void main(String[] args) throws SQLException {
        new CreateCluster().run(args);
    }

    private void run(String[] args) throws SQLException {
        String urlSource = null;
        String urlTarget = null;
        String user = null;
        String password = "";
        String serverlist = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-urlSource")) {
                urlSource = args[++i];
                continue;
            }
            if (args[i].equals("-urlTarget")) {
                urlTarget = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                password = args[++i];
                continue;
            }
            if (args[i].equals("-serverlist")) {
                serverlist = args[++i];
                continue;
            }
            this.showUsage();
            return;
        }
        if (urlSource == null || urlTarget == null || user == null || serverlist == null) {
            this.showUsage();
            return;
        }
        CreateCluster.execute(urlSource, urlTarget, user, password, serverlist);
    }

    public static void execute(String urlSource, String urlTarget, String user, String password, String serverlist) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(urlSource + ";CLUSTER=''", user, password);
            conn.close();
            try {
                conn = DriverManager.getConnection(urlTarget + ";IFEXISTS=TRUE", user, password);
                conn.close();
                throw new Exception("Target database must not yet exist. Please delete it first");
            }
            catch (SQLException e) {
                String scriptFile = "backup.sql";
                Backup.execute(urlSource, user, password, scriptFile);
                RunScript.execute(urlTarget, user, password, scriptFile, null, false);
                new File(scriptFile).delete();
                conn = DriverManager.getConnection(urlSource, user, password);
                stat = conn.createStatement();
                stat.executeUpdate("SET CLUSTER '" + serverlist + "'");
                conn.close();
                conn = DriverManager.getConnection(urlTarget, user, password);
                stat = conn.createStatement();
                stat.executeUpdate("SET CLUSTER '" + serverlist + "'");
                JdbcUtils.closeSilently(conn);
                JdbcUtils.closeSilently(stat);
            }
        }
        catch (Exception e) {
            try {
                throw Message.convert(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(conn);
                JdbcUtils.closeSilently(stat);
                throw throwable;
            }
        }
    }
}

