/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

public class Constants {
    public static final int BUILD_ID = 46;
    private static final String BUILD = "2007-04-29";
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 0;
    public static final int FILE_BLOCK_SIZE = 16;
    public static final String MAGIC_FILE_HEADER_TEXT = "-- H2 0.5/T --      ".substring(0, 15) + "\n";
    public static final String MAGIC_FILE_HEADER = "-- H2 0.5/B --      ".substring(0, 15) + "\n";
    public static final int TCP_DRIVER_VERSION = 3;
    public static final int VERSION_JDBC_MAJOR = 3;
    public static final int VERSION_JDBC_MINOR = 0;
    public static final int NULL_SORT_LOW = 1;
    public static final int NULL_SORT_HIGH = 2;
    public static final int NULL_SORT_START = 3;
    public static final int NULL_SORT_END = 4;
    public static final int NULL_SORT_DEFAULT = 1;
    public static final int DEFAULT_SERVER_PORT = 9092;
    public static final String START_URL = "jdbc:h2:";
    public static final String URL_FORMAT = "jdbc:h2:{ {.|mem:}[name] | [file:]fileName | {tcp|ssl}:[//]server[:port][,server2[:port]]/name }[;key=value...]";
    public static final String PRODUCT_NAME = "H2";
    public static final String DRIVER_NAME = "H2 JDBC Driver";
    public static final int IO_BUFFER_SIZE = 4096;
    public static final int IO_BUFFER_SIZE_COMPRESS = 131072;
    public static final int DEFAULT_CACHE_SIZE = 65536;
    public static final int CACHE_SIZE_INDEX_SHIFT = 3;
    public static final int DEFAULT_CACHE_SIZE_INDEX = 8192;
    public static final int DEFAULT_CACHE_SIZE_LINEAR_INDEX = 256;
    public static final String SUFFIX_DB_FILE = ".db";
    public static final String SUFFIX_DATA_FILE = ".data.db";
    public static final String SUFFIX_LOG_FILE = ".log.db";
    public static final String SUFFIX_INDEX_FILE = ".index.db";
    public static final String SUFFIX_HASH_FILE = ".hash.db";
    public static final String SUFFIX_LOCK_FILE = ".lock.db";
    public static final String SUFFIX_TEMP_FILE = ".temp.db";
    public static final String SUFFIX_TRACE_FILE = ".trace.db";
    public static final String SUFFIX_LOB_FILE = ".lob.db";
    public static final String SUFFIX_TRACE_START_FILE = ".start";
    public static final String SUFFIX_LOBS_DIRECTORY = ".lobs.db";
    public static final String UTF8 = "UTF8";
    public static final int DEFAULT_TABLE_TYPE = 0;
    public static final int DEFAULT_MAX_LENGTH_INPLACE_LOB = 128;
    public static final int DEFAULT_MAX_LENGTH_CLIENTSIDE_LOB = 65536;
    public static final int SALT_LEN = 8;
    public static final int DEFAULT_DATA_PAGE_SIZE = 512;
    public static final String PRIMARY_KEY_PREFIX = "PRIMARY_KEY_";
    public static final int LOCK_SLEEP = 1000;
    public static final int INITIAL_LOCK_TIMEOUT = 1000;
    public static final char DEFAULT_ESCAPE_CHAR = '\\';
    public static final int DEFAULT_HTTP_PORT = 8082;
    public static final boolean DEFAULT_HTTP_SSL = false;
    public static final boolean DEFAULT_HTTP_ALLOW_OTHERS = false;
    public static final int DEFAULT_FTP_PORT = 8021;
    public static final int DEFAULT_MAX_MEMORY_ROWS = 10000;
    public static final int DEFAULT_MAX_MEMORY_UNDO = Integer.MAX_VALUE;
    public static final int DEFAULT_WRITE_DELAY = 500;
    public static final String SERVER_PROPERTIES_TITLE = "H2 Server Properties";
    public static final String SERVER_PROPERTIES_FILE = ".h2.server.properties";
    public static final long LONG_QUERY_LIMIT_MS = 100L;
    public static final String PUBLIC_ROLE_NAME = "PUBLIC";
    public static final String TEMP_TABLE_PREFIX = "TEMP_TABLE_";
    public static final String TEMP_TABLE_TRANSACTION_PREFIX = "TEMP_TRANS_TABLE_";
    public static final int BIG_DECIMAL_SCALE_MAX = 100000;
    public static final String SCHEMA_MAIN = "PUBLIC";
    public static final String SCHEMA_INFORMATION = "INFORMATION_SCHEMA";
    public static final String DBA_NAME = "DBA";
    public static final String CHARACTER_SET_NAME = "Unicode";
    public static final String CLUSTERING_DISABLED = "''";
    public static final int LOCK_MODE_OFF = 0;
    public static final int LOCK_MODE_TABLE = 1;
    public static final int LOCK_MODE_TABLE_GC = 2;
    public static final int LOCK_MODE_READ_COMMITTED = 3;
    public static final int SELECTIVITY_DISTINCT_COUNT = 10000;
    public static final int SELECTIVITY_DEFAULT = 50;
    public static final int SELECTIVITY_ANALYZE_SAMPLE_ROWS = 10000;
    public static final int COST_ROW_OFFSET = 1000;
    public static final long FLUSH_INDEX_DELAY = 0L;
    public static final int THROTTLE_DELAY = 50;
    public static final String MANAGEMENT_DB_PREFIX = "management_db_";
    public static final String MANAGEMENT_DB_USER = "sa";
    public static final boolean SERIALIZE_JAVA_OBJECTS = true;
    public static final long DEFAULT_MAX_LOG_SIZE = 0x2000000L;
    public static final long LOG_SIZE_DIVIDER = 10L;
    public static final int ALLOW_LITERALS_NONE = 0;
    public static final int ALLOW_LITERALS_NUMBERS = 1;
    public static final int ALLOW_LITERALS_ALL = 2;
    public static final int DEFAULT_ALLOW_LITERALS = 2;
    public static final boolean AUTO_CONVERT_LOB_TO_FILES = true;
    public static final boolean ALLOW_EMPTY_BTREE_PAGES = true;
    public static final String CONN_URL_INTERNAL = "jdbc:default:connection";
    public static final String CONN_URL_COLUMNLIST = "jdbc:columnlist:connection";
    public static final int VIEW_COST_CACHE_SIZE = 64;
    public static final int VIEW_COST_CACHE_MAX_AGE = 10000;
    public static final int MAX_PARAMETER_INDEX = 100000;
    public static final boolean OPTIMIZE_EVALUATABLE_SUBQUERIES = false;
    public static final int ENCRYPTION_KEY_HASH_ITERATIONS = 1024;
    public static final String SCRIPT_SQL = "script.sql";
    public static final int CACHE_MIN_RECORDS = 16;
    public static final int MIN_WRITE_DELAY = Constants.getIntSetting("h2.minWriteDelay", 5);
    public static final boolean CHECK2 = Constants.getBooleanSetting("h2.check2", false);
    public static final boolean LOB_FILES_IN_DIRECTORIES = Constants.getBooleanSetting("h2.lobFilesInDirectories", false);
    public static final int LOB_FILES_PER_DIRECTORY = Constants.getIntSetting("h2.lobFilesPerDirectory", 256);
    public static boolean CHECK = Constants.getBooleanSetting("h2.check", true);
    public static boolean MULTI_THREADED_KERNEL = Constants.getBooleanSetting("h2.multiThreadedKernel", false);
    public static boolean RUN_FINALIZE = Constants.getBooleanSetting("h2.runFinalize", true);
    public static String SCRIPT_DIRECTORY = Constants.getStringSetting("h2.scriptDirectory", "");
    public static final boolean OPTIMIZE_MIN_MAX = Constants.getBooleanSetting("h2.optimizeMinMax", true);
    public static final boolean OPTIMIZE_IN = Constants.getBooleanSetting("h2.optimizeIn", true);
    public static final int REDO_BUFFER_SIZE = Constants.getIntSetting("h2.redoBufferSize", 262144);
    public static final boolean RECOMPILE_ALWAYS = Constants.getBooleanSetting("h2.recompileAlways", false);
    public static final boolean OPTIMIZE_SUBQUERY_CACHE = Constants.getBooleanSetting("h2.optimizeSubqueryCache", true);
    public static final boolean OVERFLOW_EXCEPTIONS = Constants.getBooleanSetting("h2.overflowExceptions", true);
    public static final boolean LOG_ALL_ERRORS = Constants.getBooleanSetting("h2.logAllErrors", false);
    public static final String LOG_ALL_ERRORS_FILE = Constants.getStringSetting("h2.logAllErrorsFile", "h2errors.txt");
    public static final int SERVER_CACHED_OBJECTS = Constants.getIntSetting("h2.serverCachedObjects", 64);
    public static final int SERVER_SMALL_RESULT_SET_SIZE = Constants.getIntSetting("h2.serverSmallResultSetSize", 100);
    public static final int EMERGENCY_SPACE_INITIAL = Constants.getIntSetting("h2.emergencySpaceInitial", 0x100000);
    public static final int EMERGENCY_SPACE_MIN = Constants.getIntSetting("h2.emergencySpaceMin", 131072);
    public static final boolean OBJECT_CACHE = Constants.getBooleanSetting("h2.objectCache", true);
    public static final int OBJECT_CACHE_SIZE = Constants.getIntSetting("h2.objectCacheSize", 1024);
    public static final int OBJECT_CACHE_MAX_PER_ELEMENT_SIZE = Constants.getIntSetting("h2.objectCacheMaxPerElementSize", 4096);
    public static final String CLIENT_TRACE_DIRECTORY = Constants.getStringSetting("h2.clientTraceDirectory", "trace.db/");

    public static String getVersion() {
        return "1.0 (2007-04-29)";
    }

    public static boolean getBooleanSetting(String name, boolean defaultValue) {
        String s = System.getProperty(name);
        if (s != null) {
            try {
                return Boolean.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String getStringSetting(String name, String defaultValue) {
        String s = System.getProperty(name);
        return s == null ? defaultValue : s;
    }

    public static int getIntSetting(String name, int defaultValue) {
        String s = System.getProperty(name);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

