/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.AggregateData;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Aggregate
extends Expression {
    public static final int COUNT_ALL = 0;
    public static final int COUNT = 1;
    public static final int SUM = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int AVG = 5;
    public static final int GROUP_CONCAT = 6;
    public static final int STDDEV_POP = 7;
    public static final int STDDEV_SAMP = 8;
    public static final int VAR_POP = 9;
    public static final int VAR_SAMP = 10;
    public static final int SOME = 11;
    public static final int EVERY = 12;
    public static final int SELECTIVITY = 13;
    private int type;
    private Expression on;
    private Expression separator;
    private ObjectArray orderList;
    private SortOrder sort;
    private int dataType;
    private int scale;
    private long precision;
    private Select select;
    private Database database;
    private boolean distinct;
    private static HashMap aggregates = new HashMap();

    private static void addAggregate(String name, int type) {
        aggregates.put(name, new Integer(type));
    }

    public static int getAggregateType(String name) {
        Integer type = (Integer)aggregates.get(name);
        return type == null ? -1 : type;
    }

    public Aggregate(Database database, int type, Expression on, Select select, boolean distinct) {
        this.database = database;
        this.type = type;
        this.on = on;
        this.select = select;
        this.distinct = distinct;
    }

    public void setOrder(ObjectArray orderBy) {
        this.orderList = orderBy;
    }

    public void setSeparator(Expression separator) {
        this.separator = separator;
    }

    private SortOrder initOrder(Session session) throws SQLException {
        int[] index = new int[this.orderList.size()];
        int[] sortType = new int[this.orderList.size()];
        for (int i = 0; i < this.orderList.size(); ++i) {
            int type;
            SelectOrderBy o = (SelectOrderBy)this.orderList.get(i);
            index[i] = i + 1;
            sortType[i] = type = o.descending ? 1 : 0;
        }
        return new SortOrder(session.getDatabase(), index, sortType);
    }

    public void updateAggregate(Session session) throws SQLException {
        Value v;
        HashMap group = this.select.getCurrentGroup();
        if (group == null) {
            return;
        }
        AggregateData data = (AggregateData)group.get(this);
        if (data == null) {
            data = new AggregateData(this.type);
            group.put(this, data);
        }
        Value value = v = this.on == null ? null : this.on.getValue(session);
        if (this.type == 6 && v != ValueNull.INSTANCE) {
            v = v.convertTo(13);
            if (this.orderList != null) {
                Value[] array = new Value[1 + this.orderList.size()];
                array[0] = v;
                for (int i = 0; i < this.orderList.size(); ++i) {
                    SelectOrderBy o = (SelectOrderBy)this.orderList.get(i);
                    array[i + 1] = o.expression.getValue(session);
                }
                v = ValueArray.get(array);
            }
        }
        data.add(this.database, this.distinct, v);
    }

    public Value getValue(Session session) throws SQLException {
        if (this.select.isQuickQuery()) {
            switch (this.type) {
                case 0: {
                    Table table = this.select.getTopTableFilter().getTable();
                    return ValueInt.get(table.getRowCount());
                }
                case 3: 
                case 4: {
                    boolean first = this.type == 3;
                    Index index = this.getColumnIndex(first);
                    Value v = index.findFirstOrLast(session, first);
                    return v;
                }
            }
            throw Message.getInternalError("type=" + this.type);
        }
        HashMap group = this.select.getCurrentGroup();
        if (group == null) {
            throw Message.getSQLException(90054, this.getSQL());
        }
        AggregateData data = (AggregateData)group.get(this);
        if (data == null) {
            data = new AggregateData(this.type);
        }
        Value v = data.getValue(this.database, this.distinct);
        if (this.type == 6) {
            ObjectArray list = data.getList();
            if (list == null || list.size() == 0) {
                return ValueNull.INSTANCE;
            }
            if (this.orderList != null) {
                try {
                    list.sort(new Comparator(){

                        public int compare(Object o1, Object o2) {
                            try {
                                Value[] a1 = ((ValueArray)o1).getList();
                                Value[] a2 = ((ValueArray)o2).getList();
                                return Aggregate.this.sort.compare(a1, a2);
                            }
                            catch (SQLException e) {
                                throw Message.getInternalError("sort", e);
                            }
                        }
                    });
                }
                catch (Error e) {
                    throw Message.convert(e);
                }
            }
            StringBuffer buff = new StringBuffer();
            String sep = this.separator == null ? "," : this.separator.getValue(session).getString();
            for (int i = 0; i < list.size(); ++i) {
                Value val = (Value)list.get(i);
                String s = val.getType() == 17 ? ((ValueArray)val).getList()[0].getString() : val.convertTo(13).getString();
                if (s == null) continue;
                if (i > 0 && sep != null) {
                    buff.append(sep);
                }
                buff.append(s);
            }
            v = ValueString.get(buff.toString());
        }
        return v;
    }

    public int getType() {
        return this.dataType;
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        if (this.on != null) {
            this.on.mapColumns(resolver, level);
        }
        if (this.orderList != null) {
            for (int i = 0; i < this.orderList.size(); ++i) {
                SelectOrderBy o = (SelectOrderBy)this.orderList.get(i);
                o.expression.mapColumns(resolver, level);
            }
        }
        if (this.separator != null) {
            this.separator.mapColumns(resolver, level);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        if (this.on != null) {
            this.on = this.on.optimize(session);
            this.dataType = this.on.getType();
            this.scale = this.on.getScale();
            this.precision = this.on.getPrecision();
        }
        if (this.orderList != null) {
            for (int i = 0; i < this.orderList.size(); ++i) {
                SelectOrderBy o = (SelectOrderBy)this.orderList.get(i);
                o.expression = o.expression.optimize(session);
            }
            this.sort = this.initOrder(session);
        }
        if (this.separator != null) {
            this.separator = this.separator.optimize(session);
        }
        switch (this.type) {
            case 6: {
                this.dataType = 13;
                this.scale = 0;
                this.precision = 0L;
                break;
            }
            case 0: 
            case 1: 
            case 13: {
                this.dataType = 4;
                this.scale = 0;
                this.precision = 0L;
                break;
            }
            case 2: 
            case 5: {
                if (DataType.supportsAdd(this.dataType)) break;
                throw Message.getSQLException(90015, this.getSQL());
            }
            case 3: 
            case 4: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.dataType = 7;
                this.precision = 17L;
                this.scale = 0;
                break;
            }
            case 11: 
            case 12: {
                this.dataType = 1;
                this.precision = 1L;
                this.scale = 0;
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.on != null) {
            this.on.setEvaluatable(tableFilter, b);
        }
        if (this.orderList != null) {
            for (int i = 0; i < this.orderList.size(); ++i) {
                SelectOrderBy o = (SelectOrderBy)this.orderList.get(i);
                o.expression.setEvaluatable(tableFilter, b);
            }
        }
        if (this.separator != null) {
            this.separator.setEvaluatable(tableFilter, b);
        }
    }

    public int getScale() {
        return this.scale;
    }

    public long getPrecision() {
        return this.precision;
    }

    /*
     * WARNING - void declaration
     */
    public String getSQL() {
        void var1_4;
        switch (this.type) {
            case 6: {
                StringBuffer buff = new StringBuffer();
                buff.append("GROUP_CONCAT(");
                buff.append(this.on.getSQL());
                if (this.orderList != null) {
                    buff.append(" ORDER BY ");
                    if (this.orderList != null) {
                        for (int i = 0; i < this.orderList.size(); ++i) {
                            SelectOrderBy o = (SelectOrderBy)this.orderList.get(i);
                            if (i > 0) {
                                buff.append(", ");
                            }
                            buff.append(o.expression.getSQL());
                            if (!o.descending) continue;
                            buff.append(" DESC");
                        }
                    }
                }
                if (this.separator != null) {
                    buff.append(" SEPARATOR ");
                    buff.append(this.separator.getSQL());
                }
                buff.append(")");
                return buff.toString();
            }
            case 0: {
                return "COUNT(*)";
            }
            case 1: {
                String text = "COUNT";
                break;
            }
            case 13: {
                String text = "SELECTIVITY";
                break;
            }
            case 2: {
                String text = "SUM";
                break;
            }
            case 3: {
                String text = "MIN";
                break;
            }
            case 4: {
                String text = "MAX";
                break;
            }
            case 5: {
                String text = "AVG";
                break;
            }
            case 7: {
                String text = "STDDEV_POP";
                break;
            }
            case 8: {
                String text = "STDDEV_SAMP";
                break;
            }
            case 9: {
                String text = "VAR_POP";
                break;
            }
            case 10: {
                String text = "VAR_SAMP";
                break;
            }
            case 12: {
                String text = "EVERY";
                break;
            }
            case 11: {
                String text = "SOME";
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        if (this.distinct) {
            return (String)var1_4 + "(DISTINCT " + this.on.getSQL() + ")";
        }
        return (String)var1_4 + StringUtils.enclose(this.on.getSQL());
    }

    public int getAggregateType() {
        return this.type;
    }

    private Index getColumnIndex(boolean first) {
        if (this.on instanceof ExpressionColumn) {
            ExpressionColumn col = (ExpressionColumn)this.on;
            Column column = col.getColumn();
            Table table = col.getTableFilter().getTable();
            Index index = table.getIndexForColumn(column, first);
            return index;
        }
        return null;
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        if (visitor.type == 1) {
            switch (this.type) {
                case 0: {
                    return visitor.table.canGetRowCount();
                }
                case 3: 
                case 4: {
                    if (!Constants.OPTIMIZE_MIN_MAX) {
                        return false;
                    }
                    boolean first = this.type == 3;
                    Index index = this.getColumnIndex(first);
                    return index != null;
                }
            }
            return false;
        }
        return !(this.on != null && !this.on.isEverything(visitor) || this.separator != null && !this.separator.isEverything(visitor));
    }

    public int getCost() {
        return this.on == null ? 1 : this.on.getCost() + 1;
    }

    static {
        Aggregate.addAggregate("COUNT", 1);
        Aggregate.addAggregate("SUM", 2);
        Aggregate.addAggregate("MIN", 3);
        Aggregate.addAggregate("MAX", 4);
        Aggregate.addAggregate("AVG", 5);
        Aggregate.addAggregate("GROUP_CONCAT", 6);
        Aggregate.addAggregate("STDDEV_SAMP", 8);
        Aggregate.addAggregate("STDDEV", 8);
        Aggregate.addAggregate("STDDEV_POP", 7);
        Aggregate.addAggregate("STDDEVP", 7);
        Aggregate.addAggregate("VAR_POP", 9);
        Aggregate.addAggregate("VARP", 9);
        Aggregate.addAggregate("VAR_SAMP", 10);
        Aggregate.addAggregate("VAR", 10);
        Aggregate.addAggregate("VARIANCE", 10);
        Aggregate.addAggregate("SOME", 11);
        Aggregate.addAggregate("EVERY", 12);
        Aggregate.addAggregate("SELECTIVITY", 13);
    }
}

