/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.security.SecureFileStore;
import org.h2.store.DataHandler;
import org.h2.store.MemoryFileStore;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.TempFileDeleter;

public class FileStore {
    public static final int HEADER_LENGTH = 48;
    protected String name;
    protected DataHandler handler;
    private byte[] magic;
    private RandomAccessFile file;
    private long filePos;
    private Reference autoDeleteReference;
    private boolean checkedWriting = true;

    public static FileStore open(DataHandler handler, String name, byte[] magic) throws SQLException {
        return FileStore.open(handler, name, magic, null, null, 0);
    }

    public static FileStore open(DataHandler handler, String name, byte[] magic, String cipher, byte[] key) throws SQLException {
        return FileStore.open(handler, name, magic, cipher, key, 1024);
    }

    public static FileStore open(DataHandler handler, String name, byte[] magic, String cipher, byte[] key, int keyIterations) throws SQLException {
        FileStore store = FileUtils.isInMemory(name) ? new MemoryFileStore(handler, name, magic) : (cipher == null ? new FileStore(handler, name, magic) : new SecureFileStore(handler, name, magic, cipher, key, keyIterations));
        return store;
    }

    protected FileStore(DataHandler handler, String name, byte[] magic) throws SQLException {
        this.handler = handler;
        this.name = name;
        this.magic = magic;
        try {
            FileUtils.createDirs(name);
            File f = new File(name);
            this.file = f.exists() && !f.canWrite() ? FileUtils.openRandomAccessFile(name, "r") : FileUtils.openRandomAccessFile(name, "rw");
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    protected FileStore(DataHandler handler, byte[] magic) {
        this.handler = handler;
        this.magic = magic;
    }

    protected byte[] generateSalt() {
        return this.magic;
    }

    protected void initKey(byte[] salt) {
    }

    public void setCheckedWriting(boolean value) {
        this.checkedWriting = value;
    }

    protected void checkWritingAllowed() throws SQLException {
        if (this.handler != null && this.checkedWriting) {
            this.handler.checkWritingAllowed();
        }
    }

    protected void checkPowerOff() throws SQLException {
        if (this.handler != null) {
            this.handler.checkPowerOff();
        }
    }

    public void init() throws SQLException {
        int len = 16;
        if (this.length() < 48L) {
            this.checkedWriting = false;
            this.writeDirect(this.magic, 0, len);
            byte[] salt = this.generateSalt();
            this.writeDirect(salt, 0, len);
            this.initKey(salt);
            this.write(this.magic, 0, len);
            this.checkedWriting = true;
        } else {
            this.seek(0L);
            byte[] buff = new byte[len];
            this.readFullyDirect(buff, 0, len);
            if (ByteUtils.compareNotNull(buff, this.magic) != 0) {
                throw Message.getSQLException(90048, this.name);
            }
            byte[] salt = new byte[len];
            this.readFullyDirect(salt, 0, len);
            this.initKey(salt);
            this.readFully(buff, 0, 16);
            if (ByteUtils.compareNotNull(buff, this.magic) != 0) {
                throw Message.getSQLException(90049, this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.file != null) {
            try {
                this.file.close();
            }
            finally {
                this.file = null;
            }
        }
    }

    public void closeSilently() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                this.file = null;
            }
        }
    }

    public void closeAndDeleteSilently() {
        if (this.file != null) {
            this.closeSilently();
            TempFileDeleter.deleteFile(this.autoDeleteReference, this.name);
            this.name = null;
        }
    }

    protected void readFullyDirect(byte[] b, int off, int len) throws SQLException {
        this.readFully(b, off, len);
    }

    public void readFully(byte[] b, int off, int len) throws SQLException {
        if (Constants.CHECK && len < 0) {
            throw Message.getInternalError("read len " + len);
        }
        if (Constants.CHECK && len % 16 != 0) {
            throw Message.getInternalError("unaligned read " + this.name + " len " + len);
        }
        this.checkPowerOff();
        try {
            this.file.readFully(b, off, len);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
        this.filePos += (long)len;
    }

    public void seek(long pos) throws SQLException {
        if (Constants.CHECK && pos % 16L != 0L) {
            throw Message.getInternalError("unaligned seek " + this.name + " pos " + pos);
        }
        try {
            if (pos != this.filePos) {
                this.file.seek(pos);
                this.filePos = pos;
            }
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    protected void writeDirect(byte[] b, int off, int len) throws SQLException {
        this.write(b, off, len);
    }

    public void write(byte[] b, int off, int len) throws SQLException {
        if (Constants.CHECK && len < 0) {
            throw Message.getInternalError("read len " + len);
        }
        if (Constants.CHECK && len % 16 != 0) {
            throw Message.getInternalError("unaligned write " + this.name + " len " + len);
        }
        this.checkWritingAllowed();
        this.checkPowerOff();
        try {
            this.file.write(b, off, len);
        }
        catch (IOException e) {
            if (this.freeUpDiskSpace()) {
                try {
                    this.file.write(b, off, len);
                }
                catch (IOException e2) {
                    throw Message.convert(e2);
                }
            }
            throw Message.convert(e);
        }
        this.filePos += (long)len;
    }

    private boolean freeUpDiskSpace() throws SQLException {
        if (this.handler == null) {
            return false;
        }
        this.handler.freeUpDiskSpace();
        return true;
    }

    public void setLength(long newLength) throws SQLException {
        if (Constants.CHECK && newLength % 16L != 0L) {
            throw Message.getInternalError("unaligned setLength " + this.name + " pos " + newLength);
        }
        this.checkPowerOff();
        this.checkWritingAllowed();
        try {
            FileUtils.setLength(this.file, newLength);
        }
        catch (IOException e) {
            if (this.freeUpDiskSpace()) {
                try {
                    FileUtils.setLength(this.file, newLength);
                }
                catch (IOException e2) {
                    throw Message.convert(e2);
                }
            }
            throw Message.convert(e);
        }
    }

    public long length() throws SQLException {
        try {
            if (Constants.CHECK && this.file.length() % 16L != 0L) {
                long newLength = this.file.length() + 16L - this.file.length() % 16L;
                FileUtils.setLength(this.file, newLength);
                throw Message.getInternalError("unaligned file length " + this.name + " len " + this.file.length());
            }
            return this.file.length();
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public long getFilePointer() throws SQLException {
        if (Constants.CHECK2) {
            try {
                if (this.file.getFilePointer() != this.filePos) {
                    throw Message.getInternalError();
                }
            }
            catch (IOException e) {
                throw Message.convert(e);
            }
        }
        return this.filePos;
    }

    public void sync() {
        try {
            this.file.getFD().sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void autoDelete() {
        this.autoDeleteReference = TempFileDeleter.addFile(this.name, this);
    }

    public void stopAutoDelete() {
        TempFileDeleter.stopAutoDelete(this.autoDeleteReference, this.name);
        this.autoDeleteReference = null;
    }

    public boolean isEncrypted() {
        return false;
    }
}

