/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.message.Message;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;

public class Backup {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-file <filename>] [-dir <dir>] [-db <database>] [-quiet]");
    }

    public static void main(String[] args) throws SQLException {
        new Backup().run(args);
    }

    private void run(String[] args) throws SQLException {
        String zipFileName = "backup.zip";
        String dir = ".";
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-db")) {
                db = args[++i];
                continue;
            }
            if (args[i].equals("-quiet")) {
                quiet = true;
                continue;
            }
            this.showUsage();
            return;
        }
        Backup.execute(zipFileName, dir, db, quiet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String zipFileName, String directory, String db, boolean quiet) throws SQLException {
        ArrayList list = FileLister.getDatabaseFiles(directory, db, true);
        if (list.size() == 0 && !quiet) {
            System.out.println("No database files found");
            return;
        }
        File file = new File(zipFileName);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ZipOutputStream zipOut = new ZipOutputStream(out);
            for (int i = 0; i < list.size(); ++i) {
                String fileName = (String)list.get(i);
                ZipEntry entry = new ZipEntry(FileUtils.getFileName(fileName));
                zipOut.putNextEntry(entry);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(fileName);
                    IOUtils.copyAndCloseInput(in, zipOut);
                }
                catch (Throwable throwable) {
                    IOUtils.closeSilently(in);
                    throw throwable;
                }
                IOUtils.closeSilently(in);
                zipOut.closeEntry();
                if (quiet) continue;
                System.out.println("processed: " + fileName);
            }
            zipOut.closeEntry();
            zipOut.close();
        }
        catch (IOException e) {
            try {
                throw Message.convert(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(out);
                throw throwable;
            }
        }
        IOUtils.closeSilently(out);
    }
}

