/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLob
extends Value {
    private int type;
    private long precision;
    private DataHandler handler;
    private int tableId;
    private int objectId;
    private String fileName;
    private boolean linked;
    private byte[] small;
    private int hash;
    private boolean compression;
    private FileStore tempFile;

    private ValueLob(int type, DataHandler handler, String fileName, int tableId, int objectId, boolean linked, long precision, boolean compression) {
        this.type = type;
        this.handler = handler;
        this.fileName = fileName;
        this.tableId = tableId;
        this.objectId = objectId;
        this.linked = linked;
        this.precision = precision;
        this.compression = compression;
    }

    private static ValueLob copy(ValueLob lob) {
        ValueLob copy = new ValueLob(lob.type, lob.handler, lob.fileName, lob.tableId, lob.objectId, lob.linked, lob.precision, lob.compression);
        copy.small = lob.small;
        copy.hash = lob.hash;
        return copy;
    }

    private ValueLob(int type, byte[] small) throws SQLException {
        this.type = type;
        this.small = small;
        if (small != null) {
            this.precision = type == 15 ? (long)small.length : (long)this.getString().length();
        }
    }

    public static ValueLob createSmallLob(int type, byte[] small) throws SQLException {
        return new ValueLob(type, small);
    }

    private static String getFileName(DataHandler handler, int tableId, int objectId) {
        if (Constants.CHECK && tableId == 0 && objectId == 0) {
            throw Message.getInternalError("0 LOB");
        }
        if (Constants.LOB_FILES_IN_DIRECTORIES) {
            String table = tableId < 0 ? ".temp" : ".t" + tableId;
            return ValueLob.getFileNamePrefix(handler.getDatabasePath(), objectId) + table + ".lob.db";
        }
        return handler.getDatabasePath() + "." + tableId + "." + objectId + ".lob.db";
    }

    public static ValueLob open(int type, DataHandler handler, int tableId, int objectId, long precision, boolean compression) {
        String fileName = ValueLob.getFileName(handler, tableId, objectId);
        return new ValueLob(type, handler, fileName, tableId, objectId, true, precision, compression);
    }

    public static ValueLob createClob(Reader in, long length, DataHandler handler) throws SQLException {
        try {
            boolean compress = handler.getLobCompressionAlgorithm(16) != null;
            long remaining = Long.MAX_VALUE;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            int len = ValueLob.getBufferSize(handler, compress, remaining);
            char[] buff = new char[len];
            int n = len = (len = IOUtils.readFully(in, buff, len)) < 0 ? 0 : len;
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = StringUtils.utf8Encode(new String(buff, 0, len));
                return ValueLob.createSmallLob(16, small);
            }
            ValueLob lob = new ValueLob(16, null);
            lob.createFromReader(buff, len, in, remaining, handler);
            return lob;
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    private static int getBufferSize(DataHandler handler, boolean compress, long remaining) {
        int bufferSize;
        int n = bufferSize = compress ? 131072 : 4096;
        while ((long)bufferSize < remaining && bufferSize <= handler.getMaxLengthInplaceLob()) {
            bufferSize += 4096;
        }
        bufferSize = (int)Math.min(remaining, (long)bufferSize);
        return bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromReader(char[] buff, int len, Reader in, long remaining, DataHandler handler) throws SQLException {
        try {
            FileStoreOutputStream out = this.initLarge(handler);
            boolean compress = handler.getLobCompressionAlgorithm(16) != null;
            try {
                do {
                    this.precision += (long)len;
                    byte[] b = StringUtils.utf8Encode(new String(buff, 0, len));
                    out.write(b, 0, b.length);
                    if ((remaining -= (long)len) <= 0L) {
                        break;
                    }
                    len = ValueLob.getBufferSize(handler, compress, remaining);
                } while ((len = IOUtils.readFully(in, buff, len)) > 0);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    private static String getFileNamePrefix(String path, int objectId) {
        int f = objectId % Constants.LOB_FILES_PER_DIRECTORY;
        String name = f > 0 ? File.separator + objectId : "";
        objectId /= Constants.LOB_FILES_PER_DIRECTORY;
        while (objectId > 0) {
            f = objectId % Constants.LOB_FILES_PER_DIRECTORY;
            name = File.separator + f + ".lobs.db" + name;
            objectId /= Constants.LOB_FILES_PER_DIRECTORY;
        }
        name = path + ".lobs.db" + name;
        return name;
    }

    private int getNewObjectId(DataHandler handler) throws SQLException {
        int fileId;
        String path = handler.getDatabasePath();
        int objectId = 0;
        while (true) {
            String dir = ValueLob.getFileNamePrefix(path, objectId);
            String[] list = FileUtils.listFiles(dir);
            int fileCount = 0;
            boolean[] used = new boolean[Constants.LOB_FILES_PER_DIRECTORY];
            for (int i = 0; i < list.length; ++i) {
                int id;
                String name = list[i];
                if (!name.endsWith(".db")) continue;
                name = name.substring(name.lastIndexOf(File.separatorChar) + 1);
                String n = name.substring(0, name.indexOf(46));
                try {
                    id = Integer.parseInt(n);
                }
                catch (NumberFormatException e) {
                    id = -1;
                }
                if (id <= 0) continue;
                ++fileCount;
                used[id % Constants.LOB_FILES_PER_DIRECTORY] = true;
            }
            fileId = -1;
            if (fileCount < Constants.LOB_FILES_PER_DIRECTORY) {
                for (int i = 1; i < Constants.LOB_FILES_PER_DIRECTORY; ++i) {
                    if (used[i]) continue;
                    fileId = i;
                    break;
                }
            }
            if (fileId > 0) break;
            if (objectId > Integer.MAX_VALUE / Constants.LOB_FILES_PER_DIRECTORY) {
                objectId = 0;
                continue;
            }
            int dirId = RandomUtils.nextInt(Constants.LOB_FILES_PER_DIRECTORY - 1) + 1;
            objectId *= Constants.LOB_FILES_PER_DIRECTORY;
            objectId += dirId * Constants.LOB_FILES_PER_DIRECTORY;
        }
        return objectId += fileId;
    }

    public static ValueLob createBlob(InputStream in, long length, DataHandler handler) throws SQLException {
        try {
            boolean compress;
            long remaining = Long.MAX_VALUE;
            boolean bl = compress = handler.getLobCompressionAlgorithm(15) != null;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            int len = ValueLob.getBufferSize(handler, compress, remaining);
            byte[] buff = new byte[len];
            int n = len = (len = IOUtils.readFully(in, buff, len)) < 0 ? 0 : len;
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = new byte[len];
                System.arraycopy(buff, 0, small, 0, len);
                return ValueLob.createSmallLob(15, small);
            }
            ValueLob lob = new ValueLob(15, null);
            lob.createFromStream(buff, len, in, remaining, handler);
            return lob;
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStoreOutputStream initLarge(DataHandler handler) throws IOException, SQLException {
        this.handler = handler;
        this.tableId = 0;
        this.linked = false;
        this.precision = 0L;
        this.small = null;
        this.hash = 0;
        String compressionAlgorithm = handler.getLobCompressionAlgorithm(this.type);
        this.compression = compressionAlgorithm != null;
        DataHandler dataHandler = handler;
        synchronized (dataHandler) {
            if (Constants.LOB_FILES_IN_DIRECTORIES) {
                this.objectId = this.getNewObjectId(handler);
                this.fileName = ValueLob.getFileNamePrefix(handler.getDatabasePath(), this.objectId) + ".temp.db";
            } else {
                this.objectId = handler.allocateObjectId(false, true);
                this.fileName = handler.createTempFile();
            }
            this.tempFile = handler.openFile(this.fileName, false);
            this.tempFile.autoDelete();
        }
        FileStoreOutputStream out = new FileStoreOutputStream(this.tempFile, handler, compressionAlgorithm);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromStream(byte[] buff, int len, InputStream in, long remaining, DataHandler handler) throws SQLException {
        try {
            FileStoreOutputStream out = this.initLarge(handler);
            boolean compress = handler.getLobCompressionAlgorithm(15) != null;
            try {
                do {
                    this.precision += (long)len;
                    out.write(buff, 0, len);
                    if ((remaining -= (long)len) <= 0L) {
                        break;
                    }
                    len = ValueLob.getBufferSize(handler, compress, remaining);
                } while ((len = IOUtils.readFully(in, buff, len)) > 0);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public Value convertTo(int t) throws SQLException {
        if (t == this.type) {
            return this;
        }
        if (t == 16) {
            ValueLob copy = ValueLob.createClob(this.getReader(), -1L, this.handler);
            return copy;
        }
        if (t == 15) {
            ValueLob copy = ValueLob.createBlob(this.getInputStream(), -1L, this.handler);
            return copy;
        }
        return super.convertTo(t);
    }

    public boolean isLinked() {
        return this.linked;
    }

    public void close() throws SQLException {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            ValueLob.deleteFile(this.handler, this.fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink() throws SQLException {
        if (this.linked && this.fileName != null) {
            DataHandler dataHandler = this.handler;
            synchronized (dataHandler) {
                String temp = Constants.LOB_FILES_IN_DIRECTORIES ? ValueLob.getFileName(this.handler, -1, this.objectId) : this.handler.createTempFile();
                ValueLob.deleteFile(this.handler, temp);
                ValueLob.renameFile(this.handler, this.fileName, temp);
                this.tempFile = FileStore.open(this.handler, temp, null);
                this.tempFile.autoDelete();
                this.tempFile.closeSilently();
                this.fileName = temp;
                this.linked = false;
            }
        }
    }

    public Value link(DataHandler handler, int tabId) throws SQLException {
        if (this.fileName == null) {
            this.tableId = tabId;
            return this;
        }
        if (this.linked) {
            ValueLob copy = ValueLob.copy(this);
            copy.objectId = Constants.LOB_FILES_IN_DIRECTORIES ? this.getNewObjectId(handler) : handler.allocateObjectId(false, true);
            copy.tableId = tabId;
            String live = ValueLob.getFileName(handler, copy.tableId, copy.objectId);
            this.copyFile(handler, this.fileName, live);
            copy.fileName = live;
            copy.linked = true;
            return copy;
        }
        if (!this.linked) {
            this.tableId = tabId;
            String live = ValueLob.getFileName(handler, this.tableId, this.objectId);
            this.tempFile.stopAutoDelete();
            this.tempFile = null;
            ValueLob.renameFile(handler, this.fileName, live);
            this.fileName = live;
            this.linked = true;
        }
        return this;
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getType() {
        return this.type;
    }

    public long getPrecision() {
        return this.precision;
    }

    public String getString() throws SQLException {
        int len = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.type == 16) {
                if (this.small != null) {
                    return StringUtils.utf8Decode(this.small);
                }
                return IOUtils.readStringAndClose(this.getReader(), len);
            }
            byte[] buff = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), len);
            return ByteUtils.convertBytesToString(buff);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public byte[] getBytes() throws SQLException {
        byte[] data = this.getBytesNoCopy();
        return ByteUtils.cloneByteArray(data);
    }

    public byte[] getBytesNoCopy() throws SQLException {
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            try {
                this.hash = ByteUtils.getByteArrayHash(this.getBytes());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.hash;
    }

    protected int compareSecure(Value v, CompareMode mode) throws SQLException {
        if (this.type == 16) {
            int c = this.getString().compareTo(v.getString());
            return c == 0 ? 0 : (c < 0 ? -1 : 1);
        }
        byte[] v2 = v.getBytesNoCopy();
        return ByteUtils.compareNotNull(this.getBytes(), v2);
    }

    public Object getObject() throws SQLException {
        if (this.type == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    public Reader getReader() throws SQLException {
        return IOUtils.getReader(this.getInputStream());
    }

    public InputStream getInputStream() throws SQLException {
        if (this.fileName == null) {
            return new ByteArrayInputStream(this.small);
        }
        FileStore store = this.handler.openFile(this.fileName, true);
        return new BufferedInputStream(new FileStoreInputStream(store, this.handler, this.compression), 4096);
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        long p = this.getPrecision();
        if (p > Integer.MAX_VALUE || p <= 0L) {
            p = -1L;
        }
        if (this.type == 15) {
            prep.setBinaryStream(parameterIndex, this.getInputStream(), (int)p);
        } else {
            prep.setCharacterStream(parameterIndex, this.getReader(), (int)p);
        }
    }

    public String getSQL() {
        try {
            if (this.type == 16) {
                String s = this.getString();
                return StringUtils.quoteStringSQL(s);
            }
            byte[] buff = this.getBytes();
            String s = ByteUtils.convertBytesToString(buff);
            return "X'" + s + "'";
        }
        catch (SQLException e) {
            throw Message.convertToInternal(e);
        }
    }

    public byte[] getSmall() {
        return this.small;
    }

    public int getDisplaySize() {
        return 40;
    }

    protected boolean isEqual(Value v) {
        try {
            return this.compareSecure(v, null) == 0;
        }
        catch (SQLException e) {
            throw Message.getInternalError("compare", e);
        }
    }

    public void convertToFileIfRequired(DataHandler handler) throws SQLException {
        if (this.small != null && this.small.length > handler.getMaxLengthInplaceLob()) {
            boolean compress = handler.getLobCompressionAlgorithm(this.type) != null;
            int len = ValueLob.getBufferSize(handler, compress, Long.MAX_VALUE);
            int tabId = this.tableId;
            if (this.type == 15) {
                this.createFromStream(new byte[len], 0, this.getInputStream(), Long.MAX_VALUE, handler);
            } else {
                this.createFromReader(new char[len], 0, this.getReader(), Long.MAX_VALUE, handler);
            }
            Value v2 = this.link(handler, tabId);
            if (Constants.CHECK && v2 != this) {
                throw Message.getInternalError();
            }
        }
    }

    public static void removeAllForTable(DataHandler handler, int tableId) throws SQLException {
        if (Constants.LOB_FILES_IN_DIRECTORIES) {
            String dir = ValueLob.getFileNamePrefix(handler.getDatabasePath(), 0);
            ValueLob.removeAllForTable(handler, dir, tableId);
        } else {
            String prefix = handler.getDatabasePath();
            String dir = FileUtils.getParent(prefix);
            String[] list = FileUtils.listFiles(dir);
            for (int i = 0; i < list.length; ++i) {
                String name = list[i];
                if (!name.startsWith(prefix + "." + tableId) || !name.endsWith(".lob.db")) continue;
                ValueLob.deleteFile(handler, name);
            }
        }
    }

    private static void removeAllForTable(DataHandler handler, String dir, int tableId) throws SQLException {
        String[] list = FileUtils.listFiles(dir);
        for (int i = 0; i < list.length; ++i) {
            if (FileUtils.isDirectory(list[i])) {
                ValueLob.removeAllForTable(handler, list[i], tableId);
                continue;
            }
            String name = list[i];
            if (!name.endsWith(".t" + tableId + ".lob.db")) continue;
            ValueLob.deleteFile(handler, name);
        }
    }

    public boolean useCompression() {
        return this.compression;
    }

    public boolean isFileBased() {
        return this.fileName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteFile(DataHandler handler, String fileName) throws SQLException {
        Object object = handler.getLobSyncObject();
        synchronized (object) {
            FileUtils.delete(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void renameFile(DataHandler handler, String oldName, String newName) throws SQLException {
        Object object = handler.getLobSyncObject();
        synchronized (object) {
            FileUtils.rename(oldName, newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(DataHandler handler, String fileName, String live) throws SQLException {
        Object object = handler.getLobSyncObject();
        synchronized (object) {
            FileUtils.copy(fileName, live);
        }
    }
}

