/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.StringUtils;

public class JdbcDatabaseMetaData
extends TraceObject
implements DatabaseMetaData {
    private JdbcConnection conn;

    public int getDriverMajorVersion() {
        this.debugCodeCall("getDriverMajorVersion");
        return 1;
    }

    public int getDriverMinorVersion() {
        this.debugCodeCall("getDriverMinorVersion");
        return 0;
    }

    public String getDatabaseProductName() {
        this.debugCodeCall("getDatabaseProductName");
        return "H2";
    }

    public String getDatabaseProductVersion() {
        this.debugCodeCall("getDatabaseProductVersion");
        return Constants.getVersion();
    }

    public String getDriverName() {
        this.debugCodeCall("getDriverName");
        return "H2 JDBC Driver";
    }

    public String getDriverVersion() {
        this.debugCodeCall("getDriverVersion");
        return Constants.getVersion();
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            String tableType;
            int i;
            if (this.debug()) {
                this.debugCode("getTables(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(tableNamePattern) + ", " + this.quoteArray(types) + ");");
            }
            this.checkClosed();
            if (types != null && types.length > 0) {
                StringBuffer buff = new StringBuffer("TABLE_TYPE IN(");
                for (i = 0; i < types.length; ++i) {
                    if (i > 0) {
                        buff.append(", ");
                    }
                    buff.append("?");
                }
                buff.append(")");
                tableType = buff.toString();
            } else {
                tableType = "TRUE";
            }
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, REMARKS, SQL FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME LIKE ? AND (" + tableType + ") " + "ORDER BY TABLE_TYPE, TABLE_SCHEMA, TABLE_NAME");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schemaPattern));
            prep.setString(3, this.getPattern(tableNamePattern));
            for (i = 0; types != null && i < types.length; ++i) {
                prep.setString(4 + i, types[i]);
            }
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getColumns(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(tableNamePattern) + ", " + this.quote(columnNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, CHARACTER_MAXIMUM_LENGTH COLUMN_SIZE, CHARACTER_MAXIMUM_LENGTH BUFFER_LENGTH, NUMERIC_SCALE DECIMAL_DIGITS, NUMERIC_PRECISION_RADIX NUM_PREC_RADIX, NULLABLE, REMARKS, COLUMN_DEFAULT COLUMN_DEF, DATA_TYPE SQL_DATA_TYPE, ZERO() SQL_DATETIME_SUB, CHARACTER_OCTET_LENGTH CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE IS_NULLABLE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME LIKE ? AND COLUMN_NAME LIKE ? ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schemaPattern));
            prep.setString(3, this.getPattern(tableNamePattern));
            prep.setString(4, this.getPattern(columnNamePattern));
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getIndexInfo(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ", " + unique + ", " + approximate + ");");
            }
            String uniqueCondition = unique ? "NON_UNIQUE=FALSE" : "TRUE";
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, NON_UNIQUE, TABLE_CATALOG INDEX_QUALIFIER, INDEX_NAME, INDEX_TYPE TYPE, ORDINAL_POSITION, COLUMN_NAME, ASC_OR_DESC, CARDINALITY, PAGES, FILTER_CONDITION FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND (" + uniqueCondition + ") " + "AND TABLE_NAME = ? " + "ORDER BY NON_UNIQUE, TYPE, TABLE_SCHEM, INDEX_NAME, ORDINAL_POSITION");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schema));
            prep.setString(3, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String tableName) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getPrimaryKeys(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, ORDINAL_POSITION KEY_SEQ, INDEX_NAME PK_NAME FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME = ? AND PRIMARY_KEY = TRUE ORDER BY COLUMN_NAME");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schema));
            prep.setString(3, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean allProceduresAreCallable() {
        this.debugCodeCall("allProceduresAreCallable");
        return true;
    }

    public boolean allTablesAreSelectable() {
        this.debugCodeCall("allTablesAreSelectable");
        return true;
    }

    public String getURL() throws SQLException {
        try {
            this.debugCodeCall("getURL");
            return this.conn.getURL();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getUserName() throws SQLException {
        try {
            this.debugCodeCall("getUserName");
            return this.conn.getUser();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.debugCodeCall("isReadOnly");
            return this.conn.isReadOnly();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean nullsAreSortedHigh() {
        this.debugCodeCall("nullsAreSortedHigh");
        return false;
    }

    public boolean nullsAreSortedLow() {
        this.debugCodeCall("nullsAreSortedLow");
        return true;
    }

    public boolean nullsAreSortedAtStart() {
        this.debugCodeCall("nullsAreSortedAtStart");
        return false;
    }

    public boolean nullsAreSortedAtEnd() {
        this.debugCodeCall("nullsAreSortedAtEnd");
        return false;
    }

    public Connection getConnection() {
        this.debugCodeCall("getConnection");
        return this.conn;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getProcedures(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(procedureNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT ALIAS_CATALOG PROCEDURE_CAT, ALIAS_SCHEMA PROCEDURE_SCHEM, ALIAS_NAME PROCEDURE_NAME, ZERO() NUM_INPUT_PARAMS, ZERO() NUM_OUTPUT_PARAMS, ZERO() NUM_RESULT_SETS, REMARKS, RETURNS_RESULT PROCEDURE_TYPE FROM INFORMATION_SCHEMA.FUNCTION_ALIASES WHERE ALIAS_CATALOG LIKE ? AND ALIAS_SCHEMA LIKE ? AND ALIAS_NAME LIKE ? ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schemaPattern));
            prep.setString(3, this.getPattern(procedureNamePattern));
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getProcedureColumns(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(procedureNamePattern) + ", " + this.quote(columnNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT ALIAS_CATALOG PROCEDURE_CAT, ALIAS_SCHEMA PROCEDURE_SCHEM, ALIAS_NAME PROCEDURE_NAME, COLUMN_NAME, COLUMN_TYPE, DATA_TYPE, TYPE_NAME, PRECISION, PRECISION LENGTH, SCALE, RADIX, NULLABLE, REMARKS FROM INFORMATION_SCHEMA.FUNCTION_COLUMNS WHERE ALIAS_CATALOG LIKE ? AND ALIAS_SCHEMA LIKE ? AND ALIAS_NAME LIKE ? AND COLUMN_NAME LIKE ?");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schemaPattern));
            prep.setString(3, this.getPattern(procedureNamePattern));
            prep.setString(4, this.getPattern(columnNamePattern));
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getSchemas() throws SQLException {
        try {
            this.debugCodeCall("getSchemas");
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT SCHEMA_NAME TABLE_SCHEM, CATALOG_NAME TABLE_CATALOG,  IS_DEFAULT FROM INFORMATION_SCHEMA.SCHEMATA ORDER BY SCHEMA_NAME");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getCatalogs() throws SQLException {
        try {
            this.debugCodeCall("getCatalogs");
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT CATALOG_NAME TABLE_CAT FROM INFORMATION_SCHEMA.CATALOGS");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getTableTypes() throws SQLException {
        try {
            this.debugCodeCall("getTableTypes");
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT TYPE TABLE_TYPE FROM INFORMATION_SCHEMA.TABLE_TYPES ORDER BY TABLE_TYPE");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getColumnPrivileges(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(table) + ", " + this.quote(columnNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME = ? AND COLUMN_NAME LIKE ? ORDER BY COLUMN_NAME, PRIVILEGE");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schema));
            prep.setString(3, table);
            prep.setString(4, this.getPattern(columnNamePattern));
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getTablePrivileges(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(tableNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES WHERE TABLE_CATALOG LIKE ? AND TABLE_SCHEMA LIKE ? AND TABLE_NAME LIKE ? ORDER BY TABLE_SCHEM, TABLE_NAME, PRIVILEGE");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schemaPattern));
            prep.setString(3, this.getPattern(tableNamePattern));
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String tableName, int scope, boolean nullable) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getBestRowIdentifier(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ", " + scope + ", " + nullable + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT CAST(? AS SMALLINT) SCOPE, C.COLUMN_NAME, C.DATA_TYPE, C.TYPE_NAME, C.CHARACTER_MAXIMUM_LENGTH COLUMN_SIZE, C.CHARACTER_MAXIMUM_LENGTH BUFFER_LENGTH, CAST(C.NUMERIC_SCALE AS SMALLINT) DECIMAL_DIGITS, CAST(? AS SMALLINT) PSEUDO_COLUMN FROM INFORMATION_SCHEMA.INDEXES I,  INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_NAME = I.TABLE_NAME AND C.COLUMN_NAME = I.COLUMN_NAME AND C.TABLE_CATALOG LIKE ? AND C.TABLE_SCHEMA LIKE ? AND C.TABLE_NAME = ? AND I.PRIMARY_KEY = TRUE ORDER BY SCOPE");
            prep.setInt(1, 2);
            prep.setInt(2, 1);
            prep.setString(3, this.getCatalogPattern(catalog));
            prep.setString(4, this.getSchemaPattern(schema));
            prep.setString(5, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getVersionColumns(String catalog, String schema, String tableName) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getVersionColumns(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT ZERO() SCOPE, COLUMN_NAME, CAST(DATA_TYPE AS INT) DATA_TYPE, TYPE_NAME, NUMERIC_PRECISION COLUMN_SIZE, NUMERIC_PRECISION BUFFER_LENGTH, NUMERIC_PRECISION DECIMAL_DIGITS, ZERO() PSEUDO_COLUMN FROM INFORMATION_SCHEMA.COLUMNS WHERE FALSE");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getImportedKeys(String catalog, String schema, String tableName) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getImportedKeys(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT PKTABLE_CATALOG PKTABLE_CAT, PKTABLE_SCHEMA PKTABLE_SCHEM, PKTABLE_NAME PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CATALOG FKTABLE_CAT, FKTABLE_SCHEMA FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, ORDINAL_POSITION KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE FKTABLE_CATALOG LIKE ? AND FKTABLE_SCHEMA LIKE ? AND FKTABLE_NAME = ? ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, FK_NAME, KEY_SEQ");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schema));
            prep.setString(3, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getExportedKeys(String catalog, String schema, String tableName) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getExportedKeys(" + this.quote(catalog) + ", " + this.quote(schema) + ", " + this.quote(tableName) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT PKTABLE_CATALOG PKTABLE_CAT, PKTABLE_SCHEMA PKTABLE_SCHEM, PKTABLE_NAME PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CATALOG FKTABLE_CAT, FKTABLE_SCHEMA FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, ORDINAL_POSITION KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE PKTABLE_CATALOG LIKE ? AND PKTABLE_SCHEMA LIKE ? AND PKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FK_NAME, KEY_SEQ");
            prep.setString(1, this.getCatalogPattern(catalog));
            prep.setString(2, this.getSchemaPattern(schema));
            prep.setString(3, tableName);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getCrossReference(" + this.quote(primaryCatalog) + ", " + this.quote(primarySchema) + ", " + this.quote(primaryTable) + ", " + this.quote(foreignCatalog) + ", " + this.quote(foreignSchema) + ", " + this.quote(foreignTable) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT PKTABLE_CATALOG PKTABLE_CAT, PKTABLE_SCHEMA PKTABLE_SCHEM, PKTABLE_NAME PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CATALOG FKTABLE_CAT, FKTABLE_SCHEMA FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, ORDINAL_POSITION KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE PKTABLE_CATALOG LIKE ? AND PKTABLE_SCHEMA LIKE ? AND PKTABLE_NAME = ? AND FKTABLE_CATALOG LIKE ? AND FKTABLE_SCHEMA LIKE ? AND FKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FK_NAME, KEY_SEQ");
            prep.setString(1, this.getCatalogPattern(primaryCatalog));
            prep.setString(2, this.getSchemaPattern(primarySchema));
            prep.setString(3, primaryTable);
            prep.setString(4, this.getCatalogPattern(foreignCatalog));
            prep.setString(5, this.getSchemaPattern(foreignSchema));
            prep.setString(6, foreignTable);
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getUDTs(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(typeNamePattern) + ", " + this.quoteIntArray(types) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT CATALOG_NAME  TYPE_CAT, CATALOG_NAME  TYPE_SCHEM, CATALOG_NAME  TYPE_NAME, CATALOG_NAME  CLASS_NAME, CAST(ZERO() AS SMALLINT) DATA_TYPE, CATALOG_NAME  REMARKS, CAST(ZERO() AS SMALLINT) BASE_TYPE FROM INFORMATION_SCHEMA.CATALOGS WHERE FALSE");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getTypeInfo() throws SQLException {
        try {
            this.debugCodeCall("getTypeInfo");
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT TYPE_NAME, DATA_TYPE, PRECISION, PREFIX LITERAL_PREFIX, SUFFIX LITERAL_SUFFIX, PARAMS CREATE_PARAMS, NULLABLE, CASE_SENSITIVE, SEARCHABLE, FALSE UNSIGNED_ATTRIBUTE, FALSE FIXED_PREC_SCALE, AUTO_INCREMENT, TYPE_NAME LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, DATA_TYPE SQL_DATA_TYPE, ZERO() SQL_DATETIME_SUB, RADIX NUM_PREC_RADIX FROM INFORMATION_SCHEMA.TYPE_INFO ORDER BY DATA_TYPE, POS");
            ResultSet rs = prep.executeQuery();
            return rs;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean usesLocalFiles() {
        this.debugCodeCall("usesLocalFiles");
        return true;
    }

    public boolean usesLocalFilePerTable() {
        this.debugCodeCall("usesLocalFilePerTable");
        return false;
    }

    public String getIdentifierQuoteString() {
        this.debugCodeCall("getIdentifierQuoteString");
        return "\"";
    }

    public String getSQLKeywords() {
        this.debugCodeCall("getSQLKeywords");
        return "";
    }

    public String getNumericFunctions() throws SQLException {
        this.debugCodeCall("getNumericFunctions");
        return this.getFunctions("Functions (Numeric)");
    }

    public String getStringFunctions() throws SQLException {
        this.debugCodeCall("getStringFunctions");
        return this.getFunctions("Functions (String)");
    }

    public String getSystemFunctions() throws SQLException {
        this.debugCodeCall("getSystemFunctions");
        return this.getFunctions("Functions (System)");
    }

    public String getTimeDateFunctions() throws SQLException {
        this.debugCodeCall("getTimeDateFunctions");
        return this.getFunctions("Functions (Time and Date)");
    }

    private String getFunctions(String section) throws SQLException {
        try {
            StringBuffer buff = new StringBuffer();
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT TOPIC FROM INFORMATION_SCHEMA.HELP WHERE SECTION = ?");
            prep.setString(1, section);
            ResultSet rs = prep.executeQuery();
            while (rs.next()) {
                String s = rs.getString(1).trim();
                String[] array = StringUtils.arraySplit(s, ',', true);
                for (int i = 0; i < array.length; ++i) {
                    String f;
                    if (buff.length() > 0) {
                        buff.append(",");
                    }
                    if ((f = array[i].trim()).indexOf(32) >= 0) {
                        f = f.substring(0, f.indexOf(32)).trim();
                    }
                    buff.append(f);
                }
            }
            rs.close();
            prep.close();
            return buff.toString();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getSearchStringEscape() {
        this.debugCodeCall("getSearchStringEscape");
        return "\\";
    }

    public String getExtraNameCharacters() {
        this.debugCodeCall("getExtraNameCharacters");
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() {
        this.debugCodeCall("supportsAlterTableWithAddColumn");
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() {
        this.debugCodeCall("supportsAlterTableWithDropColumn");
        return true;
    }

    public boolean supportsColumnAliasing() {
        this.debugCodeCall("supportsColumnAliasing");
        return true;
    }

    public boolean nullPlusNonNullIsNull() {
        this.debugCodeCall("nullPlusNonNullIsNull");
        return true;
    }

    public boolean supportsConvert() {
        this.debugCodeCall("supportsConvert");
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) {
        if (this.debug()) {
            this.debugCode("supportsConvert(" + fromType + ", " + fromType + ");");
        }
        return true;
    }

    public boolean supportsTableCorrelationNames() {
        this.debugCodeCall("supportsTableCorrelationNames");
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        this.debugCodeCall("supportsDifferentTableCorrelationNames");
        return false;
    }

    public boolean supportsExpressionsInOrderBy() {
        this.debugCodeCall("supportsExpressionsInOrderBy");
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        this.debugCodeCall("supportsOrderByUnrelated");
        return true;
    }

    public boolean supportsGroupBy() {
        this.debugCodeCall("supportsGroupBy");
        return true;
    }

    public boolean supportsGroupByUnrelated() {
        this.debugCodeCall("supportsGroupByUnrelated");
        return true;
    }

    public boolean supportsGroupByBeyondSelect() {
        this.debugCodeCall("supportsGroupByBeyondSelect");
        return true;
    }

    public boolean supportsLikeEscapeClause() {
        this.debugCodeCall("supportsLikeEscapeClause");
        return true;
    }

    public boolean supportsMultipleResultSets() {
        this.debugCodeCall("supportsMultipleResultSets");
        return false;
    }

    public boolean supportsMultipleTransactions() {
        this.debugCodeCall("supportsMultipleTransactions");
        return true;
    }

    public boolean supportsNonNullableColumns() {
        this.debugCodeCall("supportsNonNullableColumns");
        return true;
    }

    public boolean supportsMinimumSQLGrammar() {
        this.debugCodeCall("supportsMinimumSQLGrammar");
        return true;
    }

    public boolean supportsCoreSQLGrammar() {
        this.debugCodeCall("supportsCoreSQLGrammar");
        return true;
    }

    public boolean supportsExtendedSQLGrammar() {
        this.debugCodeCall("supportsExtendedSQLGrammar");
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() {
        this.debugCodeCall("supportsANSI92EntryLevelSQL");
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() {
        this.debugCodeCall("supportsANSI92IntermediateSQL");
        return false;
    }

    public boolean supportsANSI92FullSQL() {
        this.debugCodeCall("supportsANSI92FullSQL");
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        this.debugCodeCall("supportsIntegrityEnhancementFacility");
        return true;
    }

    public boolean supportsOuterJoins() {
        this.debugCodeCall("supportsOuterJoins");
        return true;
    }

    public boolean supportsFullOuterJoins() {
        this.debugCodeCall("supportsFullOuterJoins");
        return false;
    }

    public boolean supportsLimitedOuterJoins() {
        this.debugCodeCall("supportsLimitedOuterJoins");
        return true;
    }

    public String getSchemaTerm() {
        this.debugCodeCall("getSchemaTerm");
        return "schema";
    }

    public String getProcedureTerm() {
        this.debugCodeCall("getProcedureTerm");
        return "procedure";
    }

    public String getCatalogTerm() {
        this.debugCodeCall("getCatalogTerm");
        return "catalog";
    }

    public boolean isCatalogAtStart() {
        this.debugCodeCall("isCatalogAtStart");
        return true;
    }

    public String getCatalogSeparator() {
        this.debugCodeCall("getCatalogSeparator");
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() {
        this.debugCodeCall("supportsSchemasInDataManipulation");
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() {
        this.debugCodeCall("supportsSchemasInProcedureCalls");
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() {
        this.debugCodeCall("supportsSchemasInTableDefinitions");
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() {
        this.debugCodeCall("supportsSchemasInIndexDefinitions");
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        this.debugCodeCall("supportsSchemasInPrivilegeDefinitions");
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() {
        this.debugCodeCall("supportsCatalogsInDataManipulation");
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        this.debugCodeCall("supportsCatalogsInProcedureCalls");
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        this.debugCodeCall("supportsCatalogsInTableDefinitions");
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        this.debugCodeCall("supportsCatalogsInIndexDefinitions");
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        this.debugCodeCall("supportsCatalogsInPrivilegeDefinitions");
        return false;
    }

    public boolean supportsPositionedDelete() {
        this.debugCodeCall("supportsPositionedDelete");
        return true;
    }

    public boolean supportsPositionedUpdate() {
        this.debugCodeCall("supportsPositionedUpdate");
        return true;
    }

    public boolean supportsSelectForUpdate() {
        this.debugCodeCall("supportsSelectForUpdate");
        return true;
    }

    public boolean supportsStoredProcedures() {
        this.debugCodeCall("supportsStoredProcedures");
        return false;
    }

    public boolean supportsSubqueriesInComparisons() {
        this.debugCodeCall("supportsSubqueriesInComparisons");
        return true;
    }

    public boolean supportsSubqueriesInExists() {
        this.debugCodeCall("supportsSubqueriesInExists");
        return true;
    }

    public boolean supportsSubqueriesInIns() {
        this.debugCodeCall("supportsSubqueriesInIns");
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        this.debugCodeCall("supportsSubqueriesInQuantifieds");
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        this.debugCodeCall("supportsCorrelatedSubqueries");
        return true;
    }

    public boolean supportsUnion() {
        this.debugCodeCall("supportsUnion");
        return true;
    }

    public boolean supportsUnionAll() {
        this.debugCodeCall("supportsUnionAll");
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        this.debugCodeCall("supportsOpenCursorsAcrossCommit");
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        this.debugCodeCall("supportsOpenCursorsAcrossRollback");
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        this.debugCodeCall("supportsOpenStatementsAcrossCommit");
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        this.debugCodeCall("supportsOpenStatementsAcrossRollback");
        return true;
    }

    public boolean supportsTransactions() {
        this.debugCodeCall("supportsTransactions");
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) {
        this.debugCodeCall("supportsTransactionIsolationLevel");
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        this.debugCodeCall("supportsDataDefinitionAndDataManipulationTransactions");
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        this.debugCodeCall("supportsDataManipulationTransactionsOnly");
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() {
        this.debugCodeCall("dataDefinitionCausesTransactionCommit");
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() {
        this.debugCodeCall("dataDefinitionIgnoredInTransactions");
        return false;
    }

    public boolean supportsResultSetType(int type) {
        this.debugCodeCall("supportsResultSetType", type);
        return type != 1005;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        if (this.debug()) {
            this.debugCode("supportsResultSetConcurrency(" + type + ", " + concurrency + ");");
        }
        return type != 1005;
    }

    public boolean ownUpdatesAreVisible(int type) {
        this.debugCodeCall("ownUpdatesAreVisible", type);
        return false;
    }

    public boolean ownDeletesAreVisible(int type) {
        this.debugCodeCall("ownDeletesAreVisible", type);
        return false;
    }

    public boolean ownInsertsAreVisible(int type) {
        this.debugCodeCall("ownInsertsAreVisible", type);
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) {
        this.debugCodeCall("othersUpdatesAreVisible", type);
        return false;
    }

    public boolean othersDeletesAreVisible(int type) {
        this.debugCodeCall("othersDeletesAreVisible", type);
        return false;
    }

    public boolean othersInsertsAreVisible(int type) {
        this.debugCodeCall("othersInsertsAreVisible", type);
        return false;
    }

    public boolean updatesAreDetected(int type) {
        this.debugCodeCall("updatesAreDetected", type);
        return false;
    }

    public boolean deletesAreDetected(int type) {
        this.debugCodeCall("deletesAreDetected", type);
        return false;
    }

    public boolean insertsAreDetected(int type) {
        this.debugCodeCall("insertsAreDetected", type);
        return false;
    }

    public boolean supportsBatchUpdates() {
        this.debugCodeCall("supportsBatchUpdates");
        return true;
    }

    public boolean doesMaxRowSizeIncludeBlobs() {
        this.debugCodeCall("doesMaxRowSizeIncludeBlobs");
        return false;
    }

    public int getDefaultTransactionIsolation() {
        this.debugCodeCall("getDefaultTransactionIsolation");
        return 2;
    }

    public boolean supportsMixedCaseIdentifiers() {
        this.debugCodeCall("supportsMixedCaseIdentifiers");
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        this.debugCodeCall("supportsMixedCaseQuotedIdentifiers");
        return true;
    }

    public boolean storesUpperCaseIdentifiers() {
        this.debugCodeCall("storesUpperCaseIdentifiers");
        return true;
    }

    public boolean storesLowerCaseIdentifiers() {
        this.debugCodeCall("storesLowerCaseIdentifiers");
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        this.debugCodeCall("storesMixedCaseIdentifiers");
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        this.debugCodeCall("storesUpperCaseQuotedIdentifiers");
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        this.debugCodeCall("storesLowerCaseQuotedIdentifiers");
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        this.debugCodeCall("storesMixedCaseQuotedIdentifiers");
        return true;
    }

    public int getMaxBinaryLiteralLength() {
        this.debugCodeCall("getMaxBinaryLiteralLength");
        return 0;
    }

    public int getMaxCharLiteralLength() {
        this.debugCodeCall("getMaxCharLiteralLength");
        return 0;
    }

    public int getMaxColumnNameLength() {
        this.debugCodeCall("getMaxColumnNameLength");
        return 0;
    }

    public int getMaxColumnsInGroupBy() {
        this.debugCodeCall("getMaxColumnsInGroupBy");
        return 0;
    }

    public int getMaxColumnsInIndex() {
        this.debugCodeCall("getMaxColumnsInIndex");
        return 0;
    }

    public int getMaxColumnsInOrderBy() {
        this.debugCodeCall("getMaxColumnsInOrderBy");
        return 0;
    }

    public int getMaxColumnsInSelect() {
        this.debugCodeCall("getMaxColumnsInSelect");
        return 0;
    }

    public int getMaxColumnsInTable() {
        this.debugCodeCall("getMaxColumnsInTable");
        return 0;
    }

    public int getMaxConnections() {
        this.debugCodeCall("getMaxConnections");
        return 0;
    }

    public int getMaxCursorNameLength() {
        this.debugCodeCall("getMaxCursorNameLength");
        return 0;
    }

    public int getMaxIndexLength() {
        this.debugCodeCall("getMaxIndexLength");
        return 0;
    }

    public int getMaxSchemaNameLength() {
        this.debugCodeCall("getMaxSchemaNameLength");
        return 0;
    }

    public int getMaxProcedureNameLength() {
        this.debugCodeCall("getMaxProcedureNameLength");
        return 0;
    }

    public int getMaxCatalogNameLength() {
        this.debugCodeCall("getMaxCatalogNameLength");
        return 0;
    }

    public int getMaxRowSize() {
        this.debugCodeCall("getMaxRowSize");
        return 0;
    }

    public int getMaxStatementLength() {
        this.debugCodeCall("getMaxStatementLength");
        return 0;
    }

    public int getMaxStatements() {
        this.debugCodeCall("getMaxStatements");
        return 0;
    }

    public int getMaxTableNameLength() {
        this.debugCodeCall("getMaxTableNameLength");
        return 0;
    }

    public int getMaxTablesInSelect() {
        this.debugCodeCall("getMaxTablesInSelect");
        return 0;
    }

    public int getMaxUserNameLength() {
        this.debugCodeCall("getMaxUserNameLength");
        return 0;
    }

    public boolean supportsSavepoints() {
        this.debugCodeCall("supportsSavepoints");
        return true;
    }

    public boolean supportsNamedParameters() {
        this.debugCodeCall("supportsNamedParameters");
        return false;
    }

    public boolean supportsMultipleOpenResults() {
        this.debugCodeCall("supportsMultipleOpenResults");
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        this.debugCodeCall("supportsGetGeneratedKeys");
        return true;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getSuperTypes(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(typeNamePattern) + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getSuperTables(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(tableNamePattern) + ");");
            }
            this.checkClosed();
            PreparedStatement prep = this.conn.prepareAutoCloseStatement("SELECT CATALOG_NAME TABLE_CAT, CATALOG_NAME TABLE_SCHEM, CATALOG_NAME TABLE_NAME, CATALOG_NAME SUPERTABLE_NAME FROM INFORMATION_SCHEMA.CATALOGS WHERE FALSE");
            return prep.executeQuery();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("getAttributes(" + this.quote(catalog) + ", " + this.quote(schemaPattern) + ", " + this.quote(typeNamePattern) + ", " + this.quote(attributeNamePattern) + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean supportsResultSetHoldability(int holdability) {
        this.debugCodeCall("supportsResultSetHoldability", holdability);
        return holdability == 2;
    }

    public int getResultSetHoldability() {
        this.debugCodeCall("getResultSetHoldability");
        return 2;
    }

    public int getDatabaseMajorVersion() {
        this.debugCodeCall("getDatabaseMajorVersion");
        return 1;
    }

    public int getDatabaseMinorVersion() {
        this.debugCodeCall("getDatabaseMinorVersion");
        return 0;
    }

    public int getJDBCMajorVersion() throws SQLException {
        this.debugCodeCall("getJDBCMajorVersion");
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        this.debugCodeCall("getJDBCMinorVersion");
        return 0;
    }

    public int getSQLStateType() {
        this.debugCodeCall("getSQLStateType");
        return 2;
    }

    public boolean locatorsUpdateCopy() {
        this.debugCodeCall("locatorsUpdateCopy");
        return false;
    }

    public boolean supportsStatementPooling() {
        this.debugCodeCall("supportsStatementPooling");
        return false;
    }

    JdbcDatabaseMetaData(JdbcConnection conn, Trace trace, int id) {
        this.setTrace(trace, 2, id);
        this.conn = conn;
    }

    private void checkClosed() throws SQLException {
        this.conn.checkClosed();
    }

    private String getPattern(String pattern) {
        return pattern == null ? "%" : pattern;
    }

    private String getSchemaPattern(String pattern) {
        return pattern == null ? "%" : (pattern.length() == 0 ? "PUBLIC" : pattern);
    }

    private String getCatalogPattern(String catalogPattern) {
        return catalogPattern == null || catalogPattern.length() == 0 ? "%" : catalogPattern;
    }

    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.debugCodeCall("getSchemas");
        throw Message.getUnsupportedException();
    }

    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        this.debugCodeCall("supportsStoredFunctionsUsingCallSyntax");
        return true;
    }

    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        this.debugCodeCall("autoCommitFailureClosesAllResultSets");
        return false;
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        this.debugCodeCall("getClientInfoProperties");
        throw Message.getUnsupportedException();
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.debugCodeCall("getFunctionColumns");
        throw Message.getUnsupportedException();
    }

    public ResultSet getFunctions(String arg0, String arg1, String arg2) throws SQLException {
        this.debugCodeCall("getFunctions");
        throw Message.getUnsupportedException();
    }
}

