/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import org.h2.Driver;
import org.h2.server.OdbcServerThread;
import org.h2.server.Service;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;

public class OdbcServer
implements Service {
    public static final int DEFAULT_PORT = 9083;
    private int port = 9083;
    private boolean stop;
    private boolean log;
    private ServerSocket serverSocket;
    private HashSet running = new HashSet();
    private String baseDir;
    private String url;
    private boolean allowOthers;
    private boolean ifExists;

    boolean getLog() {
        return this.log;
    }

    void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    synchronized void remove(OdbcServerThread t) {
        this.running.remove(t);
    }

    void logError(Exception e) {
        if (this.log) {
            e.printStackTrace();
        }
    }

    public void init(String[] args) throws Exception {
        this.port = 9083;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.equals("-log")) {
                this.log = Boolean.valueOf(args[++i]);
                continue;
            }
            if (a.equals("-odbcPort")) {
                this.port = MathUtils.decodeInt(args[++i]);
                continue;
            }
            if (a.equals("-baseDir")) {
                this.baseDir = args[++i];
                continue;
            }
            if (a.equals("-odbcAllowOthers")) {
                this.allowOthers = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!a.equals("-ifExists")) continue;
            this.ifExists = Boolean.valueOf(args[++i]);
        }
        Driver.load();
        this.url = "tcp://localhost:" + this.port;
    }

    public String getURL() {
        return this.url;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        return NetUtils.isLoopbackAddress(socket);
    }

    public void start() throws SQLException {
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
    }

    public void listen() {
        block4: {
            String threadName = Thread.currentThread().getName();
            try {
                while (!this.stop) {
                    Socket s = this.serverSocket.accept();
                    if (!this.allow(s)) {
                        this.log("Connection not allowed");
                        s.close();
                        continue;
                    }
                    OdbcServerThread c = new OdbcServerThread(s, this);
                    this.running.add(c);
                    Thread thread = new Thread(c);
                    thread.setName(threadName + " thread");
                    c.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception e) {
                if (this.stop) break block4;
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (!this.stop) {
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.serverSocket = null;
            }
        }
        ArrayList list = new ArrayList(this.running);
        for (int i = 0; i < list.size(); ++i) {
            OdbcServerThread c = (OdbcServerThread)list.get(i);
            c.close();
            try {
                c.getThread().join(100L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createSocket(InetAddress.getLocalHost(), this.serverSocket.getLocalPort(), false);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    public String getType() {
        return "ODBC";
    }

    public boolean getIfExists() {
        return this.ifExists;
    }
}

