/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.store.UndoLogRecord;
import org.h2.util.ObjectArray;

public class UndoLog {
    private Session session;
    private Database database;
    private ObjectArray records = new ObjectArray();
    private FileStore file;
    private DataPage rowBuff;
    private int memoryUndo;

    public UndoLog(Session session) {
        this.session = session;
        this.database = session.getDatabase();
    }

    public int size() {
        if (Constants.CHECK && this.memoryUndo > this.records.size()) {
            throw Message.getInternalError();
        }
        return this.records.size();
    }

    public void clear() {
        this.records.clear();
        this.memoryUndo = 0;
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }

    public UndoLogRecord getAndRemoveLast() throws SQLException {
        int i = this.records.size() - 1;
        UndoLogRecord entry = (UndoLogRecord)this.records.get(i);
        if (entry.isStored()) {
            int start = Math.max(0, i - this.database.getMaxMemoryUndo() / 2);
            UndoLogRecord first = null;
            for (int j = start; j <= i; ++j) {
                UndoLogRecord e = (UndoLogRecord)this.records.get(j);
                if (!e.isStored()) continue;
                e.load(this.rowBuff, this.file, this.session);
                ++this.memoryUndo;
                if (first != null) continue;
                first = e;
            }
            first.seek(this.file);
        }
        this.records.remove(i);
        --this.memoryUndo;
        return entry;
    }

    public void add(UndoLogRecord entry) throws SQLException {
        this.records.add(entry);
        ++this.memoryUndo;
        if (this.memoryUndo > this.database.getMaxMemoryUndo() && this.database.isPersistent()) {
            if (this.file == null) {
                String fileName = this.database.createTempFile();
                this.file = this.database.openFile(fileName, "rw", false);
                this.file.autoDelete();
                this.file.seek(48L);
                this.rowBuff = DataPage.create((DataHandler)this.database, 512);
            }
            DataPage buff = this.rowBuff;
            for (int i = 0; i < this.records.size(); ++i) {
                UndoLogRecord r = (UndoLogRecord)this.records.get(i);
                if (r.isStored() || !r.canStore()) continue;
                r.save(buff, this.file);
                --this.memoryUndo;
            }
        }
    }
}

