/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.h2.message.Message;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class DateTimeUtils {
    public static Timestamp convertTimestampToCalendar(Timestamp x, Calendar calendar) throws SQLException {
        if (x != null) {
            Timestamp y = new Timestamp(DateTimeUtils.getLocalTime(x, calendar));
            y.setNanos(x.getNanos());
            x = y;
        }
        return x;
    }

    public static Time cloneAndNormalizeTime(Time value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.get(11);
        cal.set(1970, 0, 1);
        return new Time(cal.getTime().getTime());
    }

    public static java.sql.Date cloneAndNormalizeDate(java.sql.Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.get(1);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return new java.sql.Date(cal.getTime().getTime());
    }

    public static Value convertDateToUniversal(java.sql.Date x, Calendar source) throws SQLException {
        return ValueDate.get(new java.sql.Date(DateTimeUtils.getUniversalTime(source, x)));
    }

    public static Value convertTimeToUniversal(Time x, Calendar source) throws SQLException {
        return ValueTime.get(new Time(DateTimeUtils.getUniversalTime(source, x)));
    }

    public static Value convertTimestampToUniversal(Timestamp x, Calendar source) throws SQLException {
        Timestamp y = new Timestamp(DateTimeUtils.getUniversalTime(source, x));
        y.setNanos(x.getNanos());
        return ValueTimestamp.getNoCopy(y);
    }

    private static long getUniversalTime(Calendar source, Date x) throws SQLException {
        if (source == null) {
            throw Message.getInvalidValueException("calendar", null);
        }
        source = (Calendar)source.clone();
        Calendar universal = Calendar.getInstance();
        source.setTime(x);
        DateTimeUtils.convertTime(source, universal);
        return universal.getTime().getTime();
    }

    private static long getLocalTime(Date x, Calendar target) throws SQLException {
        if (target == null) {
            throw Message.getInvalidValueException("calendar", null);
        }
        target = (Calendar)target.clone();
        Calendar local = Calendar.getInstance();
        local.setTime(x);
        DateTimeUtils.convertTime(local, target);
        return target.getTime().getTime();
    }

    private static void convertTime(Calendar from, Calendar to) {
        to.set(1, from.get(1));
        to.set(2, from.get(2));
        to.set(5, from.get(5));
        to.set(11, from.get(11));
        to.set(12, from.get(12));
        to.set(13, from.get(13));
        to.set(14, from.get(14));
    }

    public static java.sql.Date convertDateToCalendar(java.sql.Date x, Calendar calendar) throws SQLException {
        return x == null ? null : new java.sql.Date(DateTimeUtils.getLocalTime(x, calendar));
    }

    public static Time convertTimeToCalendar(Time x, Calendar calendar) throws SQLException {
        return x == null ? null : new Time(DateTimeUtils.getLocalTime(x, calendar));
    }

    public static Date parseDateTime(String s, int type, int errorCode) throws SQLException {
        if (s == null) {
            return null;
        }
        try {
            int timeStart = 0;
            TimeZone tz = null;
            if (type == 9) {
                timeStart = 0;
            } else {
                timeStart = s.indexOf(32) + 1;
                if (timeStart <= 0) {
                    timeStart = s.indexOf(84) + 1;
                }
            }
            int year = 1970;
            int month = 1;
            int day = 1;
            if (type != 9) {
                if (s.startsWith("+")) {
                    s = s.substring(1);
                }
                int s1 = s.indexOf(45, 1);
                int s2 = s.indexOf(45, s1 + 1);
                if (s1 <= 0 || s2 <= s1) {
                    throw Message.getSQLException(errorCode, s);
                }
                year = Integer.parseInt(s.substring(0, s1));
                month = Integer.parseInt(s.substring(s1 + 1, s2));
                int end = timeStart == 0 ? s.length() : timeStart - 1;
                day = Integer.parseInt(s.substring(s2 + 1, end));
            }
            int hour = 0;
            int minute = 0;
            int second = 0;
            int nano = 0;
            if (type != 10) {
                int s1 = s.indexOf(58, timeStart);
                int s2 = s.indexOf(58, s1 + 1);
                int s3 = s.indexOf(46, s2 + 1);
                if (s1 <= 0 || s2 <= s1) {
                    throw Message.getSQLException(errorCode, s);
                }
                if (s.endsWith("Z")) {
                    s = s.substring(0, s.length() - 1);
                    tz = TimeZone.getTimeZone("UTC");
                } else {
                    int timezoneStart = s.indexOf(43, s2 + 1);
                    if (timezoneStart < 0) {
                        timezoneStart = s.indexOf(45, s2 + 1);
                    }
                    if (timezoneStart >= 0) {
                        String tzName = "GMT" + s.substring(timezoneStart);
                        tz = TimeZone.getTimeZone(tzName);
                        if (!tz.getID().equals(tzName)) {
                            throw Message.getSQLException(errorCode, s + " " + tz.getID() + "/" + tzName);
                        }
                        s = s.substring(0, timezoneStart);
                    }
                }
                hour = Integer.parseInt(s.substring(timeStart, s1));
                minute = Integer.parseInt(s.substring(s1 + 1, s2));
                if (s3 < 0) {
                    second = Integer.parseInt(s.substring(s2 + 1));
                } else {
                    second = Integer.parseInt(s.substring(s2 + 1, s3));
                    String n = (s + "000000000").substring(s3 + 1, s3 + 10);
                    nano = Integer.parseInt(n);
                }
            }
            Calendar c = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
            c.setLenient(false);
            if (year <= 0) {
                c.set(0, 0);
                c.set(1, 1 - year);
            } else {
                c.set(1, year);
            }
            c.set(2, month - 1);
            c.set(5, day);
            c.set(11, hour);
            c.set(12, minute);
            c.set(13, second);
            if (type != 11) {
                c.set(14, nano / 1000000);
            }
            long time = c.getTime().getTime();
            switch (type) {
                case 10: {
                    return new java.sql.Date(time);
                }
                case 9: {
                    return new Time(time);
                }
                case 11: {
                    Timestamp ts = new Timestamp(time);
                    ts.setNanos(nano);
                    return ts;
                }
            }
            throw Message.getInternalError("type:" + type);
        }
        catch (IllegalArgumentException e) {
            throw Message.getSQLException(errorCode, new String[]{s}, e);
        }
    }
}

