/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.topic.ReliableMessageListener;
import com.hazelcast.topic.impl.reliable.MessageRunner;
import com.hazelcast.topic.impl.reliable.ReliableTopicMessage;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.version.MemberVersion;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;

public class ClientReliableMessageRunner<E>
extends MessageRunner<E> {
    ClientReliableMessageRunner(String id, ReliableMessageListener<E> listener, Ringbuffer<ReliableTopicMessage> ringbuffer, String topicName, int batchSze, SerializationService serializationService, Executor executor, ConcurrentMap<String, MessageRunner<E>> runnersMap, ILogger logger) {
        super(id, listener, ringbuffer, topicName, batchSze, serializationService, executor, runnersMap, logger);
    }

    @Override
    protected void updateStatistics() {
    }

    @Override
    protected Member getMember(ReliableTopicMessage m) {
        MemberImpl member = null;
        if (m.getPublisherAddress() != null) {
            member = new MemberImpl(m.getPublisherAddress(), MemberVersion.UNKNOWN);
        }
        return member;
    }

    @Override
    protected boolean handleInternalException(Throwable t) {
        if (t instanceof HazelcastClientNotActiveException) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Terminating MessageListener " + this.listener + " on topic: " + this.topicName + ".  Reason: HazelcastClient is shutting down");
            }
            return false;
        }
        if (t instanceof HazelcastClientOfflineException) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("MessageListener " + this.listener + " on topic: " + this.topicName + " got exception: " + t + ". Continuing from last known sequence: " + this.sequence);
            }
            return true;
        }
        return super.handleInternalException(t);
    }

    @Override
    protected Throwable adjustThrowable(Throwable t) {
        return ExceptionUtil.peel(t);
    }

    @Override
    protected long getHeadSequence(StaleSequenceException staleSequenceException) {
        return this.ringbuffer.headSequence();
    }
}

