/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.XmlClientFailoverConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.Preconditions;
import java.io.InputStream;
import java.util.Properties;

public class ClientFailoverClasspathXmlConfig
extends ClientFailoverConfig {
    private static final ILogger LOGGER = Logger.getLogger(ClientFailoverClasspathXmlConfig.class);

    public ClientFailoverClasspathXmlConfig(String resource) {
        this(resource, System.getProperties());
    }

    public ClientFailoverClasspathXmlConfig(String resource, Properties properties) {
        this(Thread.currentThread().getContextClassLoader(), resource, properties);
    }

    public ClientFailoverClasspathXmlConfig(ClassLoader classLoader, String resource, Properties properties) {
        Preconditions.checkTrue((classLoader != null ? 1 : 0) != 0, (String)"classLoader can't be null");
        Preconditions.checkTrue((resource != null ? 1 : 0) != 0, (String)"resource can't be null");
        Preconditions.checkTrue((properties != null ? 1 : 0) != 0, (String)"properties can't be null");
        LOGGER.info("Configuring Hazelcast Client Failover from '" + resource + "'.");
        InputStream in = classLoader.getResourceAsStream(resource);
        Preconditions.checkTrue((in != null ? 1 : 0) != 0, (String)("Specified resource '" + resource + "' could not be found!"));
        XmlClientFailoverConfigBuilder configBuilder = new XmlClientFailoverConfigBuilder(in);
        configBuilder.setProperties(properties);
        configBuilder.build(this);
    }
}

