/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.local.Invalidation;
import com.hazelcast.hibernate.serialization.Expirable;
import com.hazelcast.hibernate.serialization.ExpiryMarker;
import com.hazelcast.hibernate.serialization.MarkerWrapper;
import com.hazelcast.hibernate.serialization.Value;
import com.hazelcast.hibernate.shaded.caffeine.cache.Caffeine;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.MessageListener;
import java.time.Duration;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.SoftLock;

public class LocalRegionCache
implements RegionCache {
    private static final int MAX_SIZE = 100000;
    protected final HazelcastInstance hazelcastInstance;
    protected final ITopic<Object> topic;
    protected final UUID listenerRegistrationId;
    protected final MessageListener<Object> messageListener;
    protected final ConcurrentMap<Object, Expirable> cache;
    protected final Comparator versionComparator;
    protected final AtomicLong markerIdCounter;
    protected MapConfig config;
    private final EvictionConfig evictionConfig;

    public LocalRegionCache(String name, HazelcastInstance hazelcastInstance, CacheDataDescription metadata) {
        this(name, hazelcastInstance, metadata, true);
    }

    public LocalRegionCache(String name, HazelcastInstance hazelcastInstance, CacheDataDescription metadata, boolean withTopic) {
        this(name, hazelcastInstance, metadata, withTopic, null);
    }

    public LocalRegionCache(String name, HazelcastInstance hazelcastInstance, CacheDataDescription metadata, boolean withTopic, EvictionConfig evictionConfig) {
        this.hazelcastInstance = hazelcastInstance;
        try {
            this.config = hazelcastInstance != null ? hazelcastInstance.getConfig().findMapConfig(name) : null;
        }
        catch (UnsupportedOperationException ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
        this.versionComparator = metadata != null && metadata.isVersioned() ? metadata.getVersionComparator() : null;
        this.markerIdCounter = new AtomicLong();
        this.messageListener = this.ignoreMessagesFromLocalMember(this.createMessageListener());
        if (withTopic && hazelcastInstance != null) {
            this.topic = hazelcastInstance.getTopic(name);
            this.listenerRegistrationId = this.topic.addMessageListener(this.messageListener);
        } else {
            this.topic = null;
            this.listenerRegistrationId = null;
        }
        this.evictionConfig = evictionConfig == null ? EvictionConfig.create(this.config) : evictionConfig;
        this.cache = Caffeine.newBuilder().maximumSize(this.evictionConfig.getMaxSize()).expireAfterWrite(this.resolveTTL()).build().asMap();
    }

    @Override
    public Object get(Object key, long txTimestamp) {
        Expirable value = (Expirable)this.cache.get(key);
        return value == null ? null : value.getValue(txTimestamp);
    }

    @Override
    public boolean insert(Object key, Object value, Object currentVersion) {
        Value newValue = new Value(currentVersion, this.nextTimestamp(), value);
        return this.cache.putIfAbsent(key, newValue) == null;
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version) {
        block2: {
            while (true) {
                Expirable previous = (Expirable)this.cache.get(key);
                Value newValue = new Value(version, this.nextTimestamp(), value);
                if (previous == null) {
                    if (this.cache.putIfAbsent(key, newValue) != null) continue;
                    return true;
                }
                if (!previous.isReplaceableBy(txTimestamp, version, this.versionComparator)) break block2;
                if (this.cache.replace(key, previous, newValue)) break;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean update(Object key, Object newValue, Object newVersion, SoftLock softLock) {
        boolean updated = false;
        while (true) {
            Expirable revised;
            Expirable original = (Expirable)this.cache.get(key);
            long timestamp = this.nextTimestamp();
            if (original == null) {
                revised = new Value(newVersion, timestamp, newValue);
                updated = true;
                if (this.cache.putIfAbsent(key, revised) != null) continue;
                break;
            }
            if (!(softLock instanceof MarkerWrapper)) break;
            ExpiryMarker unwrappedMarker = ((MarkerWrapper)softLock).getMarker();
            if (original.matches(unwrappedMarker)) {
                ExpiryMarker marker = (ExpiryMarker)original;
                if (marker.isConcurrent()) {
                    revised = marker.expire(timestamp);
                    updated = false;
                } else {
                    revised = new Value(newVersion, timestamp, newValue);
                    updated = true;
                }
                if (!this.cache.replace(key, original, revised)) continue;
                break;
            }
            if (original.getValue() == null) {
                updated = false;
                break;
            }
            revised = new ExpiryMarker(newVersion, timestamp, this.nextMarkerId()).expire(timestamp);
            updated = false;
            if (this.cache.replace(key, original, revised)) break;
        }
        this.maybeNotifyTopic(key, newValue, newVersion);
        return updated;
    }

    protected void maybeNotifyTopic(Object key, Object value, Object version) {
        if (this.topic != null) {
            this.topic.publish(this.createMessage(key, value, version));
        }
    }

    protected Object createMessage(Object key, Object value, Object currentVersion) {
        return new Invalidation(key, currentVersion);
    }

    protected MessageListener<Object> createMessageListener() {
        return message -> this.maybeInvalidate(message.getMessageObject());
    }

    @Override
    public boolean remove(Object key) {
        Expirable value = (Expirable)this.cache.remove(key);
        this.maybeNotifyTopic(key, null, value == null ? null : value.getVersion());
        return value != null;
    }

    @Override
    public SoftLock tryLock(Object key, Object version) {
        long timeout;
        ExpiryMarker marker;
        Expirable original;
        String markerId = this.nextMarkerId();
        do {
            original = (Expirable)this.cache.get(key);
            timeout = this.nextTimestamp() + (long)CacheEnvironment.getDefaultCacheTimeoutInMillis();
        } while (!(original == null ? this.cache.putIfAbsent(key, marker = new ExpiryMarker(version, timeout, markerId)) == null : this.cache.replace(key, original, marker = original.markForExpiration(timeout, markerId))));
        return new MarkerWrapper(marker);
    }

    @Override
    public void unlock(Object key, SoftLock lock) {
        ExpiryMarker revised;
        ExpiryMarker unwrappedMarker;
        Expirable original;
        while ((original = (Expirable)this.cache.get(key)) != null && lock instanceof MarkerWrapper && !(original.matches(unwrappedMarker = ((MarkerWrapper)lock).getMarker()) ? this.cache.replace(key, original, revised = ((ExpiryMarker)original).expire(this.nextTimestamp())) : original.getValue() == null || this.cache.remove(key, original))) {
        }
        this.maybeNotifyTopic(key, null, null);
    }

    @Override
    public boolean contains(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.maybeNotifyTopic(null, null, null);
    }

    @Override
    public void destroy() {
        if (this.topic != null && this.listenerRegistrationId != null) {
            this.topic.removeMessageListener(this.listenerRegistrationId);
        }
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public long getSizeInMemory() {
        return 0L;
    }

    @Override
    public Map asMap() {
        return this.cache;
    }

    protected void maybeInvalidate(Object messageObject) {
        Invalidation invalidation = (Invalidation)messageObject;
        Object key = invalidation.getKey();
        if (key == null) {
            this.cache.clear();
        } else if (this.versionComparator == null) {
            this.cache.remove(key);
        } else {
            Expirable value = (Expirable)this.cache.get(key);
            if (value != null) {
                this.maybeInvalidateVersionedEntity(key, value, invalidation.getVersion());
            }
        }
    }

    private void maybeInvalidateVersionedEntity(Object key, Expirable value, Object newVersion) {
        if (newVersion == null) {
            this.cache.remove(key);
        } else {
            Object currentVersion = value.getVersion();
            if (this.versionComparator.compare(currentVersion, newVersion) < 0) {
                this.cache.remove(key, value);
            }
        }
    }

    private String nextMarkerId() {
        return Long.toString(this.markerIdCounter.getAndIncrement());
    }

    protected long nextTimestamp() {
        return this.hazelcastInstance == null ? Clock.currentTimeMillis() : HazelcastTimestamper.nextTimestamp(this.hazelcastInstance);
    }

    private Duration resolveTTL() {
        return Math.max(this.evictionConfig.getTimeToLive().toMillis(), 0L) == 0L ? Duration.ofMillis(Integer.MAX_VALUE) : this.evictionConfig.getTimeToLive();
    }

    private MessageListener<Object> ignoreMessagesFromLocalMember(MessageListener<Object> delegate) {
        return message -> {
            if (message.getPublishingMember() == null || this.hazelcastInstance == null || !message.getPublishingMember().equals(this.hazelcastInstance.getCluster().getLocalMember())) {
                delegate.onMessage(message);
            }
        };
    }

    public static interface EvictionConfig {
        public Duration getTimeToLive();

        public int getMaxSize();

        public static EvictionConfig create(final MapConfig mapConfig) {
            return new EvictionConfig(){

                @Override
                public Duration getTimeToLive() {
                    return mapConfig == null ? Duration.ofMillis(CacheEnvironment.getDefaultCacheTimeoutInMillis()) : Duration.ofSeconds(mapConfig.getTimeToLiveSeconds());
                }

                @Override
                public int getMaxSize() {
                    return mapConfig == null ? 100000 : mapConfig.getEvictionConfig().getSize();
                }
            };
        }
    }
}

