/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.region.AbstractHazelcastRegion;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

abstract class AbstractGeneralRegion<T extends RegionCache>
extends AbstractHazelcastRegion<T>
implements GeneralDataRegion {
    private final T cache;

    protected AbstractGeneralRegion(HazelcastInstance instance, String name, Properties props, T cache) {
        super(instance, name, props);
        this.cache = cache;
    }

    public void evict(Object key) throws CacheException {
        try {
            this.getCache().remove(key);
        }
        catch (OperationTimeoutException e) {
            Logger.getLogger(AbstractGeneralRegion.class).finest((Throwable)e);
        }
    }

    public void evictAll() throws CacheException {
        try {
            this.getCache().clear();
        }
        catch (OperationTimeoutException e) {
            Logger.getLogger(AbstractGeneralRegion.class).finest((Throwable)e);
        }
    }

    public Object get(SharedSessionContractImplementor session, Object key) throws CacheException {
        try {
            return this.getCache().get(key, this.nextTimestamp());
        }
        catch (OperationTimeoutException e) {
            return null;
        }
    }

    public void put(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        try {
            this.getCache().put(key, value, this.nextTimestamp(), null);
        }
        catch (OperationTimeoutException e) {
            Logger.getLogger(AbstractGeneralRegion.class).finest((Throwable)e);
        }
    }

    @Override
    public T getCache() {
        return this.cache;
    }
}

