/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.hibernate.region.CacheKeyImpl;
import com.hazelcast.hibernate.region.NaturalIdCacheKey;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class HazelcastCacheKeysFactory
implements CacheKeysFactory {
    public Object createCollectionKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return new CacheKeyImpl(id, persister.getKeyType(), persister.getRole(), tenantIdentifier, factory);
    }

    public Object createEntityKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return new CacheKeyImpl(id, persister.getIdentifierType(), persister.getRootEntityName(), tenantIdentifier, factory);
    }

    public Object createNaturalIdKey(Object[] naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return new NaturalIdCacheKey(naturalIdValues, persister.getPropertyTypes(), persister.getNaturalIdentifierProperties(), persister.getRootEntityName(), (SessionImplementor)session);
    }

    public Object getEntityId(Object cacheKey) {
        return ((CacheKeyImpl)cacheKey).getId();
    }

    public Object getCollectionId(Object cacheKey) {
        return ((CacheKeyImpl)cacheKey).getId();
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return ((NaturalIdCacheKey)cacheKey).getNaturalIdValues();
    }
}

