/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.hibernate.serialization.CacheEntryImpl;
import com.hazelcast.hibernate.serialization.Hibernate52CacheEntrySerializer;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;

public class Hibernate5CacheEntrySerializerHook
implements SerializerHook {
    private static final String SKIP_INIT_MSG = "Hibernate 5 not available, skipping serializer initialization";
    private final Class<?> cacheEntryClass;

    public Hibernate5CacheEntrySerializerHook() {
        Class<CacheEntryImpl> cacheEntryClass = null;
        try {
            Class.forName("org.hibernate.cache.spi.entry.CacheEntry");
            cacheEntryClass = CacheEntryImpl.class;
        }
        catch (Exception e) {
            Logger.getLogger(Hibernate5CacheEntrySerializerHook.class).finest(SKIP_INIT_MSG);
        }
        this.cacheEntryClass = cacheEntryClass;
    }

    public Class getSerializationType() {
        return this.cacheEntryClass;
    }

    public Serializer createSerializer() {
        return new Hibernate52CacheEntrySerializer();
    }

    public boolean isOverwritable() {
        return true;
    }
}

